﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Kolory
{
    public partial class Form1 : Form
    {
        bool czyAktualizowaćKolorPanelu = true;

        public Form1()
        {
            InitializeComponent();
        }

        private void trackBar1_ValueChanged(object sender, EventArgs e)
        {
            if(czyAktualizowaćKolorPanelu)
                panel1.BackColor = Color.FromArgb(trackBar1.Value, trackBar2.Value, trackBar3.Value);

            //if (panel1.BackColor.GetBrightness() < 0.5) label8.ForeColor = Color.White;
            //else label8.ForeColor = Color.Black;
            label8.ForeColor = (panel1.BackColor.GetBrightness() < 0.5) ? Color.White : Color.Black;                        

            //TrackBar trackBar = null;
            //if(sender is TrackBar)  trackBar = (TrackBar)sender;
            TrackBar trackBar = sender as TrackBar;
            if (trackBar == trackBar1)
            {                
                label5.Text = trackBar.Value.ToString();
                //if (trackBar.Value < 16) label5.Text = "0" + label5.Text;
            }
            if (trackBar == trackBar2) label6.Text = trackBar.Value.ToString();
            if (trackBar == trackBar3) label7.Text = trackBar.Value.ToString();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            trackBar1_ValueChanged(null, null);
            trackBar4.Value = (int)(this.Opacity * trackBar4.Maximum);

            Properties.Settings ustawienia = new Properties.Settings();
            this.Left = ustawienia.Left;
            this.Top = ustawienia.Top;
            this.Width = ustawienia.Width;
            this.Height = ustawienia.Height;
            trackBar1.Value = ustawienia.R;
            trackBar2.Value = ustawienia.G;
            trackBar3.Value = ustawienia.B;
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {            
            //e.Cancel = true;
        }

        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            Properties.Settings ustawienia = new Properties.Settings();
            ustawienia.Left = this.Left;
            ustawienia.Top = this.Top;
            ustawienia.Width = this.Width;
            ustawienia.Height = this.Height;
            ustawienia.R = (byte)trackBar1.Value;
            ustawienia.G = (byte)trackBar2.Value;
            ustawienia.B = (byte)trackBar3.Value;
            ustawienia.Save();

            for (; this.Opacity > 0.0; this.Opacity -= 0.005) System.Threading.Thread.Sleep(1);
        }

        private void trackBar4_Scroll(object sender, EventArgs e)
        {
            TrackBar tb = sender as TrackBar;
            this.Opacity = tb.Value / (double)tb.Maximum;
        }

        private void Form1_KeyPress(object sender, KeyPressEventArgs e)
        {
        }

        private void Form1_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.Control && e.KeyCode == Keys.C)
            {
                Clipboard.SetText("#" + trackBar1.Value.ToString("X2") + trackBar2.Value.ToString("X2") + trackBar3.Value.ToString("X2"));
            }
        }

        private void panel1_Click(object sender, EventArgs e)
        {
            colorDialog1.Color = panel1.BackColor;
            DialogResult dr = colorDialog1.ShowDialog();
            if (dr == DialogResult.OK)
            {
                panel1.BackColor = colorDialog1.Color;
                czyAktualizowaćKolorPanelu = false;
                trackBar1.Value = panel1.BackColor.R;
                trackBar2.Value = panel1.BackColor.G;
                trackBar3.Value = panel1.BackColor.B;
                czyAktualizowaćKolorPanelu = true;
            }
        }

        private void panel1_MouseEnter(object sender, EventArgs e)
        {
            label8.Visible = true;
        }

        private void panel1_MouseLeave(object sender, EventArgs e)
        {
            label8.Visible = false;
        }
    }
}
