﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Windows.Forms;

namespace Notatnik
{
    //using StreamReader = System.IO.StreamReader;
    using System.IO;

    static class PlikiTekstowe
    {
        public static bool CzytajPlikTekstowy(string ścieżkaPliku, out string[] wiersze)
        {
            //najlepsza praktyka
            //using(StreamReader sr = new StreamReader(ścieżkaPliku))
            //{
            //}

            List<string> listaWierszy = new List<string>();

            StreamReader sr = null;
            try
            {
                sr = new StreamReader(ścieżkaPliku, Encoding.Default);
                string wiersz = null;
                while ((wiersz = sr.ReadLine()) != null)
                    listaWierszy.Add(wiersz);
                wiersze = listaWierszy.ToArray();
                return true;
            }
            catch (Exception exc)
            {
                MessageBox.Show(
                    "Błąd! " + exc.Message,
                    "Błąd",
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Error);
                wiersze = null;
                return false;
            }
            finally
            {
                if (sr != null) sr.Close();
            }
        }

        public static bool ZapiszDoPlikuTekstowego(string ścieżkaPliku, string[] wiersze)
        {
            try
            {
                using (StreamWriter sw = new StreamWriter(ścieżkaPliku))
                {
                    foreach (string wiersz in wiersze) sw.WriteLine(wiersz);
                }
                return true;
            }
            catch (Exception exc)
            {
                MessageBox.Show(
                    "Błąd! " + exc.Message,
                    "Błąd",
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Error);
                return false;
            }
        }

        public static void LoadFromFile(this TextBox textBox, string filePath)
        {
            string[] wiersze;
            if (PlikiTekstowe.CzytajPlikTekstowy(filePath, out wiersze))
                textBox.Lines = wiersze;
        }

        public static void SaveToFile(this TextBox textBox, string filePath)
        {
            ZapiszDoPlikuTekstowego(filePath, textBox.Lines);
        }
    }
}
