﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace UlamekTestyJednostkowe
{
    using UMK.Fizyka;

    [TestClass]
    public class UlamekTesty
    {
        [TestMethod]
        public void TestPusty()
        {
        }

        Random r = new Random();

        private int losujLiczbęCałkowitą(int? maksymalnaBezwzględnaWartość = null)
        {
            if (!maksymalnaBezwzględnaWartość.HasValue)
                return r.Next(int.MinValue, int.MaxValue);
            else
            {
                maksymalnaBezwzględnaWartość = Math.Abs(maksymalnaBezwzględnaWartość.Value);
                return r.Next(-maksymalnaBezwzględnaWartość.Value, maksymalnaBezwzględnaWartość.Value);
            }
        }

        private int losujLiczbęCałkowitąRóżnąOdZera(int? maksymalnaBezwzględnaWartość = null)
        {
            int wartość;
            do
            {
                wartość = losujLiczbęCałkowitą(maksymalnaBezwzględnaWartość);
            }
            while (wartość == 0);
            return wartość;
        }

        

        [TestMethod]
        public void TestKonstruktora()
        {
            //assert
            int licznik = losujLiczbęCałkowitą();
            int mianownik = losujLiczbęCałkowitąRóżnąOdZera();

            //act
            Ulamek u = new Ulamek(licznik, mianownik);

            //assert
            PrivateObject priv = new PrivateObject(u);
            int u_licznik = (int)priv.GetField("licznik");
            int u_mianownik = (int)priv.GetField("mianownik");
            Assert.AreEqual(licznik, u_licznik, "Niezgodność w liczniku");
            Assert.AreEqual(mianownik, u_mianownik, "Niezgodność w mianowniku");            
        }

        [TestMethod]
        public void TestKonstruktoraIWłasności()
        {
            //assert - przygotowanie
            int licznik = losujLiczbęCałkowitą();
            int mianownik = losujLiczbęCałkowitąRóżnąOdZera();

            //act - działanie
            Ulamek u = new Ulamek(licznik, mianownik);

            //assert - weryfikacja
            Assert.AreEqual(licznik, u.Licznik, "Niezgodność w liczniku");
            Assert.AreEqual(mianownik, u.Mianownik, "Niezgodność w mianowniku");
        }

        [TestMethod]
        [ExpectedException(typeof(ArgumentException))]
        public void TestKonstruktoraWyjatek()
        {
            Ulamek u = new Ulamek(losujLiczbęCałkowitą(), 0);
        }

        [TestMethod]
        public void TestPolaStatycznegoPolowa()
        {
            Ulamek uP = Ulamek.Polowa;
            Assert.AreEqual(1, uP.Licznik);
            Assert.AreEqual(2, uP.Mianownik);
        }

        [TestMethod]
        public void TestMetodyUprosc()
        {
            Ulamek u = new Ulamek(4, -2);

            u.Uprosc();

            Assert.AreEqual(-2, u.Licznik);
            Assert.AreEqual(1, u.Mianownik);
        }

        [TestMethod]
        public void TestOperatorow()
        {
            Ulamek a = Ulamek.Polowa;
            Ulamek b = Ulamek.Cwierc;

            Assert.AreEqual(new Ulamek(3, 4), a + b, "Niepowodzenie przy dodawaniu");
            Assert.AreEqual(new Ulamek(1, 4), a - b, "Niepowodzenie przy odejmowaniu");
            Assert.AreEqual(new Ulamek(1, 8), a * b, "Niepowodzenie przy mnożeniu");
            Assert.AreEqual(new Ulamek(2), a / b, "Niepowodzenie przy dzieleniu");
        }

        [TestMethod]
        public void TestSortowania()
        {
            //arrange
            Ulamek[] tablica = new Ulamek[100];
            for (int i = 0; i < tablica.Length; ++i)
            {
                tablica[i] = new Ulamek(
                    losujLiczbęCałkowitą(),
                    losujLiczbęCałkowitąRóżnąOdZera());
            }

            //act
            Array.Sort(tablica);

            //assert
            bool czyTablicaJestPosortowanaRosnaco = true;
            for (int i = 0; i < tablica.Length - 1; ++i)
                if (tablica[i] >= tablica[i + 1])
                {
                    czyTablicaJestPosortowanaRosnaco = false;
                    break;
                }
            Assert.IsTrue(czyTablicaJestPosortowanaRosnaco);
        }

        const int liczbaPowtorzen = 10000;

        [TestMethod]
        public void TestKonwersjiDoDouble()
        {
            for (int i = 0; i < liczbaPowtorzen; ++i)
            {
                int licznik = losujLiczbęCałkowitą();
                int mianownik = losujLiczbęCałkowitąRóżnąOdZera();
                Ulamek u = new Ulamek(licznik, mianownik);

                double d = (double)u;

                Assert.AreEqual(licznik / (double)mianownik, d);
            }
        }

        [TestMethod]
        public void TestMetodyUprosc2()
        {
            for (int i = 0; i < liczbaPowtorzen; ++i)
            {
                Ulamek u = new Ulamek(losujLiczbęCałkowitą(), losujLiczbęCałkowitąRóżnąOdZera());
                Ulamek kopia = u; //klonowanie

                u.Uprosc();

                Assert.AreEqual(kopia.ToDouble(), u.ToDouble());
            }
        }

        [TestMethod]
        public void TestOperatorow2()
        {
            int limit = (int)(Math.Sqrt(int.MaxValue / 2) - 1);

            double dokladnosc = 1E-10;

            for (int i = 0; i < liczbaPowtorzen; ++i)
            {
                Ulamek a = new Ulamek(losujLiczbęCałkowitą(limit), losujLiczbęCałkowitąRóżnąOdZera(limit));
                Ulamek b = new Ulamek(losujLiczbęCałkowitą(limit), losujLiczbęCałkowitąRóżnąOdZera(limit));

                double suma = (a + b).ToDouble();
                double roznica = (a - b).ToDouble();
                double iloczyn = (a * b).ToDouble();
                double iloraz = (a / b).ToDouble();

                Assert.AreEqual(a.ToDouble() + b.ToDouble(), suma, dokladnosc, "Niepowodzenie przy dodawaniu");
                Assert.AreEqual(a.ToDouble() - b.ToDouble(), roznica, dokladnosc, "Niepowodzenie przy odejmowaniu");
                Assert.AreEqual(a.ToDouble() * b.ToDouble(), iloczyn, dokladnosc, "Niepowodzenie przy mnożeniu");
                Assert.AreEqual(a.ToDouble() / b.ToDouble(), iloraz, dokladnosc, "Niepowodzenie przy dzieleniu");
            }
        }
    }
}
