﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.ComponentModel;
using System.Windows;
using System.Windows.Input;

namespace AsystentZakupówWPF.ModelWidoku
{
    using Model;
    
    public class ModelWidoku : INotifyPropertyChanged
    {
        private SumowanieKwot model = new SumowanieKwot(1000);

        public string Suma
        {
            get
            {
                return model.Suma.ToString();
            }
        }

        public bool CzyŁańcuchKwotyJestPoprawny(string s)
        {
            if (string.IsNullOrWhiteSpace(s)) return false;
            decimal kwota;
            if (!decimal.TryParse(s, out kwota)) return false;
            else return model.CzyKwotaJestPoprawna(kwota);
        }

        private ICommand dodajKwotęCommand;        

        public ICommand DodajKwotę
        {
            get
            {
                if (dodajKwotęCommand == null)
                    dodajKwotęCommand = new RelayCommand(
                        (object argument) =>
                        {
                            try
                            {
                                decimal kwota = decimal.Parse((string)argument);
                                model.Dodaj(kwota);
                                OnPropertyChanged("Suma");
                            }
                            catch (Exception exc)
                            {
                                MessageBox.Show(exc.Message, "Asystent zakupów", MessageBoxButton.OK, MessageBoxImage.Error); //niekanoniczne
                            }
                        },
                        (object argument) =>
                        {
                            return CzyŁańcuchKwotyJestPoprawny((string)argument);
                        }
                        );
                return dodajKwotęCommand;
            }
        }

        public event PropertyChangedEventHandler PropertyChanged;

        private void OnPropertyChanged(string nazwaWłasności)
        {
            if (PropertyChanged != null)
                PropertyChanged(this, new PropertyChangedEventArgs(nazwaWłasności));
        }
    }
}
