﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Input;

namespace AsystentZakupówUA.ViewModels
{
    public class ModelWidoku : INotifyPropertyChanged
    {
        public event PropertyChangedEventHandler PropertyChanged;

        private void OnSumaPropertyChanged()
        {
            if (PropertyChanged != null)
                PropertyChanged(this, new PropertyChangedEventArgs("Suma"));
        }

        private Models.Autosumowanie model = new Models.Autosumowanie(1000);
        public decimal Suma
        {
            get
            {
                return model.Suma;
            }
        }

        private ICommand dodajDoSumy;
        public ICommand DodajDoSumy
        {
            get
            {
                if (dodajDoSumy == null)
                    dodajDoSumy = new RelayCommand(
                        (object parametr) => 
                        { 
                            decimal kwota = decimal.Parse(parametr as string);
                            model.DodajKwote(kwota);
                            OnSumaPropertyChanged();
                        },
                        (object parametr) =>
                        {
                            if(!(parametr is string)) return false;
                            decimal kwota = decimal.Parse(parametr as string);
                            return model.CzyMoznaDodacKwote(kwota);
                        });
                return dodajDoSumy;
            }
        }
    }
}
