﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;

namespace Kolokwium2
{

    public class InformacjeOKlasie
    {
        //public string NazwaKlasy {get; set;}
        public Type T;
        private int pole;

        [Obsolete]
        public int Własność { get; set; }

        private int metoda(int a)
        {
            return a;
        }

        [Author("Jacek Matulewski")]
        public int Metoda(int b)
        {
            return b;
        }

        public InformacjeOKlasie(string nazwaKlasy)
        {
            //NazwaKlasy = nazwaKlasy;
            T = Type.GetType(nazwaKlasy);
        }

        [Author("Marcin Kuligowski")]
        public string[] InformacjeOWłasnościach()
        {
            List<string> nazwyWłasności = new List<string>();
            PropertyInfo[] własności = T.GetRuntimeProperties().ToArray();
            foreach (PropertyInfo własność in własności)
            {
                string opisWłasności = własność.PropertyType.Name + " " + własność.Name + " ";
                IEnumerable<Attribute> atrybuty = własność.GetCustomAttributes();
                foreach(Attribute atrybut in atrybuty) opisWłasności += ", atrybut: " + atrybut.GetType().Name;
                nazwyWłasności.Add(opisWłasności);
            }
            return nazwyWłasności.ToArray();
        }

        public string[] InformacjeOPolach()
        {
            List<string> nazwyPól = new List<string>();
            FieldInfo[] pola = T.GetRuntimeFields().ToArray();
            foreach (FieldInfo pole in pola)
            {
                nazwyPól.Add(pole.FieldType.Name + " " + pole.Name + " " + pole.Attributes);
            }
            return nazwyPól.ToArray();
        }

        [Author("Marcin Kuligowski")]
        public string[] InformacjeOMetodach()
        {
            List<string> sygnaturyMetod = new List<string>();
            MethodInfo[] metody = T.GetRuntimeMethods().ToArray();
            foreach (MethodInfo metoda in metody)
            {
                string sygnatura = metoda.ReturnType.Name + "  " + metoda.Name + "(";
                foreach (ParameterInfo parametr in metoda.GetParameters())
                {
                    sygnatura += parametr.ParameterType.Name + " " + parametr.Name;
                }
                sygnatura += ")";
                Attribute a = metoda.GetCustomAttribute(typeof(Author));
                if (a != null)
                {
                    Author aa = a as Author;
                    sygnatura += ", autor: " + aa.Name;

                }
                sygnaturyMetod.Add(sygnatura);
            }
            return sygnaturyMetod.ToArray();
        }
    }
}
