﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.IO;

namespace NotatnikNET
{
    public partial class Form1 : Form
    {
        private bool czyTekstZmieniony = false;
        private string ścieżkaPliku = "";

        public Form1()
        {
            InitializeComponent();
        }

        private void otwórzToolStripMenuItem_Click(object sender, EventArgs e)
        {
            DialogResult dr = openFileDialog1.ShowDialog();
            if (dr == DialogResult.OK)
            {
                ścieżkaPliku = openFileDialog1.FileName;
                textBox1.Lines = File.ReadAllLines(ścieżkaPliku);                
                czyTekstZmieniony = false;
            }
        }

        private void zapiszJakoToolStripMenuItem_Click(object sender, EventArgs e)
        {
            DialogResult dr = saveFileDialog1.ShowDialog();
            if (dr == DialogResult.OK)
            {
                zapiszDoPliku(saveFileDialog1.FileName, textBox1.Lines);                
            }
        }

        private void zapiszDoPliku(string ścieżkaPliku, string[] linie)
        {
            this.ścieżkaPliku = ścieżkaPliku;
            File.WriteAllLines(ścieżkaPliku, textBox1.Lines);
            toolStripStatusLabel1.Text = "Zapisano do pliku " + ścieżkaPliku;
            czyTekstZmieniony = false;
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            e.Cancel = !pytajOZapisanieDoPliku();
        }

        private bool pytajOZapisanieDoPliku()
        {
            if (!czyTekstZmieniony) return true;

            DialogResult dr = MessageBox.Show(
                "Czy chcesz zapisać zmiany do pliku?", Text,
                MessageBoxButtons.YesNoCancel, MessageBoxIcon.Question, MessageBoxDefaultButton.Button3);
            switch (dr)
            {
                case DialogResult.Yes:
                    zapiszJakoToolStripMenuItem_Click(null, EventArgs.Empty);
                    return true;
                case DialogResult.No:
                    return true;
                default:
                case DialogResult.Cancel:
                    return false;
            }
        }

        private void nowyToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (pytajOZapisanieDoPliku()) textBox1.Text = "";
        }

        private void zakończToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void textBox1_TextChanged(object sender, EventArgs e)
        {
            czyTekstZmieniony = true;
        }

        private void toolStripMenuItem3_Click(object sender, EventArgs e)
        {
            if (string.IsNullOrWhiteSpace(ścieżkaPliku)) zapiszDoPliku(ścieżkaPliku, textBox1.Lines);
            else zapiszJakoToolStripMenuItem_Click(sender, e);
        }
    }
}
