﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.IO;

namespace NotatnikNET
{
    private struct Zakładka
    {
        int indeks = -1;
        public bool CzyTekstZmieniony = false;
        public string ŚcieżkaPliku = "";
        public TextBox textBox = null;
    }

    public partial class Form1 : Form
    {
        List<Zakładka> zakładki = new List<Zakładka>(); !!!!!!!!!!

        private bool czyTekstZmieniony = false;
        private string ścieżkaPliku = "";

        public Form1()
        {
            InitializeComponent();
        }

        private void otwórzToolStripMenuItem_Click(object sender, EventArgs e)
        {
            DialogResult dr = openFileDialog1.ShowDialog();
            if (dr == DialogResult.OK)
            {
                ścieżkaPliku = openFileDialog1.FileName;
                toolStripStatusLabel1.Text = "Wczytano plik " + ścieżkaPliku;
                textBox.Lines = File.ReadAllLines(ścieżkaPliku);                
                czyTekstZmieniony = false;
            }
        }

        private void zapiszJakoToolStripMenuItem_Click(object sender, EventArgs e)
        {
            DialogResult dr = saveFileDialog1.ShowDialog();
            if (dr == DialogResult.OK)
            {
                zapiszDoPliku(saveFileDialog1.FileName, textBox.Lines);                
            }
        }

        private void zapiszDoPliku(string ścieżkaPliku, string[] linie)
        {
            this.ścieżkaPliku = ścieżkaPliku;
            File.WriteAllLines(ścieżkaPliku, textBox.Lines);
            toolStripStatusLabel1.Text = "Zapisano do pliku " + ścieżkaPliku;
            czyTekstZmieniony = false;
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            e.Cancel = !pytajOZapisanieDoPliku();
        }

        private bool pytajOZapisanieDoPliku()
        {
            if (!czyTekstZmieniony) return true;

            DialogResult dr = MessageBox.Show(
                "Czy chcesz zapisać zmiany do pliku?", Text,
                MessageBoxButtons.YesNoCancel, MessageBoxIcon.Question, MessageBoxDefaultButton.Button3);
            switch (dr)
            {
                case DialogResult.Yes:
                    zapiszJakoToolStripMenuItem_Click(null, EventArgs.Empty);
                    return true;
                case DialogResult.No:
                    return true;
                default:
                case DialogResult.Cancel:
                    return false;
            }
        }

        private void nowyToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (pytajOZapisanieDoPliku()) textBox.Text = "";
        }

        private void zakończToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void textBox1_TextChanged(object sender, EventArgs e)
        {
            czyTekstZmieniony = true;
            toolStripStatusLabel1.Text = "Liczba znaków: " + textBox.Text.Length.ToString();
        }

        private void toolStripMenuItem3_Click(object sender, EventArgs e)
        {
            if (string.IsNullOrWhiteSpace(ścieżkaPliku)) zapiszDoPliku(ścieżkaPliku, textBox.Lines);
            else zapiszJakoToolStripMenuItem_Click(sender, e);
        }

        private void cofnijToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox.Undo();            
        }

        private void wytnijToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox.Cut();
        }

        private void kopiujToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox.Copy();
        }

        private void wklejToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox.Paste();
        }

        private void usuńToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox.SelectedText = "";
        }

        private void edycjaToolStripMenuItem_DropDownOpened(object sender, EventArgs e)
        {
            cofnijToolStripMenuItem.Enabled = textBox.CanUndo;

            bool czyZaznaczonyTekst = string.IsNullOrEmpty(textBox.SelectedText);
            wytnijToolStripMenuItem.Enabled = !czyZaznaczonyTekst;
            kopiujToolStripMenuItem.Enabled = !czyZaznaczonyTekst;            
            usuńToolStripMenuItem.Enabled = !czyZaznaczonyTekst;
        }

        private void zaznaczWszystkoToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox.SelectAll();
        }

        private void godzinaDataToolStripMenuItem_Click(object sender, EventArgs e)
        {
            DateTime now = DateTime.Now;
            textBox.SelectedText = now.ToShortTimeString() + " " + now.ToShortDateString();
        }

        private void zawijanieWierszyToolStripMenuItem_CheckedChanged(object sender, EventArgs e)
        {
            textBox.WordWrap = zawijanieWierszyToolStripMenuItem.Checked;
        }

        private void czcionkaToolStripMenuItem_Click(object sender, EventArgs e)
        {
            fontDialog1.Font = textBox.Font;
            fontDialog1.Color = textBox.ForeColor;
            DialogResult dr = fontDialog1.ShowDialog();
            if (dr == DialogResult.OK)
            {
                textBox.Font = fontDialog1.Font;
                textBox.ForeColor = fontDialog1.Color;
            }
        }

        private void kolorTłaToolStripMenuItem_Click(object sender, EventArgs e)
        {
            colorDialog1.Color = textBox.BackColor;
            DialogResult dr = colorDialog1.ShowDialog();
            if (dr == DialogResult.OK)
            {
                textBox.BackColor = colorDialog1.Color;
            }
        }

        private void pasekStanuToolStripMenuItem_CheckedChanged(object sender, EventArgs e)
        {
            statusStrip1.Visible = pasekStanuToolStripMenuItem.Checked;
        }

        private void tabControl1_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (tabControl1.SelectedIndex == tabControl1.TabCount - 1)
            {
                TabPage newTabPage = new TabPage("Nowa zakładka");
                TextBox newTextBox = new TextBox();
                newTabPage.Controls.Add(newTextBox);
                newTextBox.Multiline = true;
                newTextBox.AcceptsReturn = true;
                newTextBox.AcceptsTab = true;
                newTextBox.ScrollBars = ScrollBars.Both;
                newTextBox.Dock = DockStyle.Fill;
                tabControl1.TabPages.Insert(tabControl1.TabCount - 1, newTabPage);
                tabControl1.SelectedTab = newTabPage;
            }
        }
    }
}
