﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
//using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace Notatnik
{
    public partial class FindDialog : Form
    {
        private TextBox textBox;

        public FindDialog(TextBox textBox)
        {
            this.textBox = textBox;

            InitializeComponent();
        }

        private void button2_Click(object sender, EventArgs e)
        {
            Hide();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            int poczatekSzukania = textBox.SelectionStart;
            if (textBox.SelectedText == textBox1.Text) poczatekSzukania += textBox1.Text.Length;
            int indeksPoczatku = textBox.Text.IndexOf(textBox1.Text, poczatekSzukania);
            if (indeksPoczatku == -1)
            {
                MessageBox.Show("Nie można odnaleźć \"" + textBox1.Text + "\"", "Notatnik.NET", MessageBoxButtons.OK, MessageBoxIcon.Information);
                return;
            }
            textBox.Select(indeksPoczatku, textBox1.Text.Length);
            textBox.ScrollToCaret();
        }

        public int ZnajdzNastepny(string tekstDoZnalezienia = null)
        {
            if (tekstDoZnalezienia != null) textBox1.Text = tekstDoZnalezienia;
            button1_Click(null, null);
            return textBox.SelectionStart;
        }

        private void textBox1_TextChanged(object sender, EventArgs e)
        {
            button1.Enabled = textBox1.Text.Length > 0;
        }

        private void FindDialog_FormClosing(object sender, FormClosingEventArgs e)
        {
            e.Cancel = true;
            Hide();
        }
    }
}
