﻿using System.ComponentModel;

namespace KoloryWPF.ModelWidoku
{
    using Model;    

    public class ModelKoloru : INotifyPropertyChanged
    {
        private Model.Kolor model = Model.DAL.Czytaj();

        public event PropertyChangedEventHandler PropertyChanged;

        private void OnPropertyChanged(params string[] nazwyWłasności)
        {
            if (PropertyChanged != null)            
                foreach (string nazwaWłasności in nazwyWłasności)
                    PropertyChanged(this, new PropertyChangedEventArgs(nazwaWłasności));
        }

        public byte R
        {
            get
            {
                return model.R;
            }
            set
            {
                model.R = value;
                OnPropertyChanged("R", "Pędzel");
            }
        }

        public byte G
        {
            get
            {
                return model.G;
            }
            set
            {
                model.G = value;
                OnPropertyChanged("G", "Pędzel");
            }
        }

        public byte B
        {
            get
            {
                return model.B;
            }
            set
            {
                model.B = value;
                OnPropertyChanged("B", "Pędzel");
            }
        }

        public void Zapisz()
        {
            //Model.DAL.Zapisz(model);
            model.Zapisz();
        }

        public System.Windows.Media.SolidColorBrush Pędzel
        {
            get
            {
                return new System.Windows.Media.SolidColorBrush(
                    System.Windows.Media.Color.FromRgb(R, G, B));
            }
        }
    }
}
