﻿using System.ComponentModel;
using System.Windows.Input;

namespace ModelWidoku
{
    public class EdycjaSumy : INotifyPropertyChanged
    {
        private Sumowanie.Sumowanie model = new Sumowanie.Sumowanie(0, 1000);

        public event PropertyChangedEventHandler PropertyChanged;

        private void OnPropertyChanged(string propertyName)
        {
            if (PropertyChanged != null)
                PropertyChanged(this, new PropertyChangedEventArgs(propertyName));
        }
        public decimal Suma
        {
            get
            {
                return model.Suma;
            }
        }

        private ICommand dodajKwote;
        public ICommand DodajKwotę
        {
            get
            {
                if (dodajKwote == null)
                    dodajKwote = new MvvmCommand(
                        (object param) =>
                        {
                            decimal kwota = (decimal)param;
                            model.DodajKwotę(kwota);
                            OnPropertyChanged(nameof(Suma));
                        },
                        (object param) =>
                        {
                            try
                            {
                                decimal kwota = (decimal)param;
                                if (kwota <= 0) return false;
                                return model.TestujKwote(kwota);
                            }
                            catch
                            {
                                return false;
                            }
                        });
                return dodajKwote;
            }
        }
       
    }
}
