﻿using System;
using System.Windows.Input;

namespace ModelWidoku
{
    public class MvvmCommand : ICommand
    {
        Action<object> execute;
        Predicate<object> canExecute;

        public MvvmCommand(Action<object> execute, Predicate<object> canExecute = null)
        {
            if (execute == null) throw new ArgumentNullException();
            this.execute = execute;
            this.canExecute = canExecute;
        }

        public event EventHandler CanExecuteChanged
        {
            add
            {
                if (canExecute != null) CommandManager.RequerySuggested += value;
            }
            remove
            {
                if (canExecute != null) CommandManager.RequerySuggested -= value;
            }
        }

        public bool CanExecute(object parameter)
        {
            //if (canExecute == null) return true;
            //else return canExecute(parameter);
            return (canExecute == null) ? true : canExecute(parameter);            
        }

        public void Execute(object parameter)
        {
            execute(parameter);
        }
    }
}
