﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Lambda
{
    class Program
    {
        //Func<int, long> func1 = (int argument) => { return argument * argument; };

        static long Kwadrat(int argument)
        {
            return (long)argument * argument;
        }

        static double Kwadrat(double argument)
        {
            return argument * argument;
        }

        static long Sześcian(int argument)
        {
            return argument * argument * argument;
        }

        delegate long Metoda(int argument);        

        static void Main(string[] args)
        {
            long wartość = Kwadrat(1234);
            Console.WriteLine(wartość);

            Metoda metoda;
            if (true) metoda = Kwadrat;
            else metoda = Sześcian;

            wartość = metoda(1234);
            Console.WriteLine(wartość);

            Func<int, long> func = Kwadrat;
            wartość = func(1234);
            Console.WriteLine(wartość);

            Func<int, long> func1 = (int argument) => { return (long)argument * argument; }; //wyrażenie Lambda
            wartość = func1(1234);
            Console.WriteLine(wartość);

            wartość = Rozszerzenie.Kwadrat(1234);
            Console.WriteLine(wartość);

            wartość = 1234.Kwadrat();
            Console.WriteLine(wartość);

            Console.WriteLine(PierwszaPochodna_a(Kwadrat, 0.0, 0.0001));
            Console.WriteLine(PierwszaPochodna_b(Kwadrat, 0.0, 0.0001));
            Console.WriteLine(DrugaPochodna(Kwadrat, 0.0, 0.0001));
            Console.WriteLine(PierwszaPochodna_b((double x) => { return x * x; }, 0.0, 0.0001));
            Console.WriteLine(PierwszaPochodna_b(x => x * x, 0.0, 0.0001));

            Console.WriteLine("d'Artagnan".UsuńApostrof());
            Console.WriteLine("d'Artagnan".UsuńApostrof('$'));
            Console.WriteLine("d'Artagnan".UsuńApostrof((char znak) => { return znak == '\'' ? '@' : znak; }));
        }

        delegate double Funkcja(double x); //Func<double,double>

        static double PierwszaPochodna_a(Funkcja f, double x, double dx)
        {
            return (f(x + dx) - f(x)) / dx;            
        }

        static double PierwszaPochodna_b(Funkcja f, double x, double dx)
        {
            return (f(x + dx) - f(x - dx)) / (2 * dx);
        }

        static double DrugaPochodna(Funkcja f, double x, double dx)
        {
            return (f(x + dx) - 2 * f(x) + f(x - dx)) / (dx * dx);
        }
    }

    //rozszerzenia, metody rozszerzające, extensions, extension methods
    static class Rozszerzenie
    {
        public static long Kwadrat(this int argument)
        {
            return (long)argument * argument;
        }

        public static string UsuńApostrof(this string s)
        {
            return s.Replace('\'', '#');
        }

        public static string UsuńApostrof(this string s, char znak = '\'')
        {
            return s.Replace('\'', znak);
        }

        public static string UsuńApostrof(this string s, Func<char,char> znakoZastępowacz)
        {
            string wynik = "";
            for (int i = 0; i < s.Length; ++i) wynik += znakoZastępowacz(s[i]);
            return wynik;
        }
    }
}
