﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ParallelFor
{
    class Program
    {
        static object coś = new object();

        static double obliczenia(double argument)
        {
            for (int i = 0; i < 10; ++i)
                argument = Math.Asin(Math.Sin(argument));
            return argument;
        }

        static void Main(string[] args)
        {
            int rozmiar = 10000;
            Random r = new Random();
            double[] tablica = new double[rozmiar];
            for (int i = 0; i < tablica.Length; ++i)
                tablica[i] = r.NextDouble();

            int liczbaPowtórzeń = 100;
            int t1, t2;

            //obliczenia sekwencyjne
            {
                double[] wyniki = new double[tablica.Length];
                int start = System.Environment.TickCount;
                for (int powtórzenia = 0; powtórzenia < liczbaPowtórzeń; powtórzenia++)
                    for (int i = 0; i < tablica.Length; ++i)
                        wyniki[i] = obliczenia(tablica[i]);
                int stop = System.Environment.TickCount;
                t1 = stop - start;
                Console.WriteLine("TT1: " + t1.ToString());
            }

            //obliczenia równoległe
            {
                object o = new object();
                double[] wyniki = new double[tablica.Length];
                int start = System.Environment.TickCount;
                for (int powtórzenia = 0; powtórzenia < liczbaPowtórzeń; powtórzenia++)
                    Parallel.For(0, tablica.Length, (int i) => { wyniki[i] = obliczenia(tablica[i]); });
                int stop = System.Environment.TickCount;
                t2 = stop - start;
                Console.WriteLine("TT2: " + t2.ToString());
            }

            Console.WriteLine("Przyspieszenie: " + (t1 / t2).ToString());
        }
    }
}
