﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ProgramowanieWspółbieżne
{
    class Program
    {
        static Task<long> ZróbCośAsync(object _argument)
        {
            Func<object, long> akcja =
                    (object argument) =>
                    {
                        Console.WriteLine("Początek działania akcji - " + argument.ToString());
                        System.Threading.Thread.Sleep(500);
                        Console.WriteLine("Koniec działania akcji - " + argument.ToString());
                        return DateTime.Now.Ticks;

                    };

            Task<long> zadanie = new Task<long>(akcja, _argument);
            zadanie.Start();
            return zadanie;
        }

        static void Main(string[] args)
        {
            /*
            Func<object, long> akcja =
                (object argument) =>
                {
                    Console.WriteLine("Początek działania akcji - " + argument.ToString());
                    System.Threading.Thread.Sleep(500);
                    Console.WriteLine("Koniec działania akcji - " + argument.ToString());
                    return DateTime.Now.Ticks;
                };

            //synchroniczne
            //long wynik = akcja("synchronicznie");
            //Console.WriteLine("Synchronicznie: " + wynik.ToString());

            Task<long> zadanie = new Task<long>(akcja, "zadanie");
            zadanie.Start();
            Console.WriteLine("Zadanie zostało uruchomione");
            long wynik = zadanie.Result; //punktem synchronizacji
            Console.WriteLine("Zadanie: " + wynik.ToString());
            */

            //Task<long> zadanie = ZróbCośAsync("metoda");
            //Console.WriteLine("Metoda Async została uruchomiona");
            //long wynik = zadanie.Result; //punktem synchronizacji
            //Console.WriteLine("Metoda: " + wynik.ToString());

            SubRoutine();
            Console.WriteLine("Naciśnij coś"); Console.ReadLine();
        }

        private static async void SubRoutine()
        {
            long wynik = await ZróbCośAsync("metoda");
            Console.WriteLine("Metoda-await: " + wynik.ToString());
        }
    }
}
