﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace DragNDrop
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();

            for(int i = 0; i < 10; ++i)
            {
                listBox1.Items.Add("Lista 1, pozycja " + i.ToString());
                listBox2.Items.Add("Lista 2, pozycja " + i.ToString());
            }
        }

        #region Obsługa drag & drop
        private void listBox1_MouseDown(object sender, MouseEventArgs e)
        {
            listBox1.DoDragDrop(listBox1.SelectedItem, DragDropEffects.Copy | DragDropEffects.Move);
        }

        private void listBox2_DragOver(object sender, DragEventArgs e)
        {
            if((e.KeyState & 8) == 8) e.Effect = DragDropEffects.Copy;
            else e.Effect = DragDropEffects.Move;
        }

        private void listBox2_DragDrop(object sender, DragEventArgs e)
        {
            listBox2.Items.Add(listBox1.SelectedItem);
            if (e.Effect == DragDropEffects.Move) listBox1.Items.Remove(listBox1.SelectedItem);
        }
        #endregion
    }
}
