﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Wyjatki
{
    class Program
    {
        class WyjątekDzieleniaPrzezZero : Exception
        {
            public WyjątekDzieleniaPrzezZero(string message = "", Exception innerException = null)
                : base(message, innerException)
            { }
        }

        static Random r = new Random();

        static int wylosujMianownik()
        {
            try
            {
                int wartość = r.Next(10);
                if (wartość > 5) throw new Exception("Nie lubię większych od 5");
                return wartość;
            }
            catch(Exception exc)
            {
                throw new Exception("Wyjątek zewnętrzny", exc);
            }
        }

        static void Main(string[] args)
        {
            początek: //!!!!!!!!!!

            try
            {
                int licznik = 1;
                int mianownik = wylosujMianownik();
                if (mianownik == 0) throw new WyjątekDzieleniaPrzezZero("Próba dzielenia przez 0");
                int d = licznik / mianownik;
                Console.WriteLine("d=" + d.ToString());
                return;
            }
            catch (WyjątekDzieleniaPrzezZero exc)
            {
                Console.WriteLine("Błąd dzielenia przez zero: " + exc.Message);
            }
            catch (Exception exc)
            {
                Console.WriteLine("Błąd typu " + exc.GetType().Name + ": " + exc.Message);
                if(exc.InnerException != null)
                    Console.WriteLine("Błąd wewnętrzny typu " + exc.InnerException.GetType().Name + ": " + exc.InnerException.Message);
            }
            finally
            {
                Console.WriteLine("Finally");
            }

            Console.Write("Naciśnij ENTER");
            Console.ReadLine();
            goto początek; //!!!!!!!!!!
        }
    }
}
