﻿using Microsoft.Win32;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
//using System.Windows.Shapes;
using System.IO;
using JacekMatulewski.WpfUtils;

namespace NotatnikWPF
{
    /// <summary>
    /// Logika interakcji dla klasy MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        private OpenFileDialog openFileDialog;
        private SaveFileDialog saveFileDialog;

        private string ścieżkaPliku = null;
        private bool czyTekstZmieniony = false;

        public MainWindow()
        {
            System.Threading.Thread.CurrentThread.CurrentUICulture = new System.Globalization.CultureInfo("en");
            InitializeComponent();


            openFileDialog = new OpenFileDialog();
            openFileDialog.Title = Properties.Resources.OtworzPlikTekstowy;
            openFileDialog.DefaultExt = "txt";
            openFileDialog.Filter = "Pliki tekstowe (*.txt)|*.txt|Pliki XML (*.xml)|*.xml|Pliki C# (*.cs)|*.cs|Wszystkie pliki (*.*)|*.*";
            openFileDialog.FilterIndex = 1;

            saveFileDialog = new SaveFileDialog();
            saveFileDialog.Title = "Zapisz plik tekstowy";
            saveFileDialog.DefaultExt = "txt";
            saveFileDialog.Filter = openFileDialog.Filter;
            saveFileDialog.FilterIndex = 1;
        }

        #region Menu Plik
        private void OtwórzMenuItem_Click(object sender, RoutedEventArgs e)
        {
            if (!string.IsNullOrEmpty(ścieżkaPliku))
            {
                openFileDialog.InitialDirectory = Path.GetDirectoryName(ścieżkaPliku);
                openFileDialog.FileName = Path.GetFileName(ścieżkaPliku);
            }

            bool? wynik = openFileDialog.ShowDialog();
            if (wynik.HasValue && wynik.Value)
            {
                ścieżkaPliku = openFileDialog.FileName;
                textBox.Text = File.ReadAllText(ścieżkaPliku);
                statusBarText.Text = Path.GetFileName(ścieżkaPliku);
                czyTekstZmieniony = false;
            }
        }

        private void ZapiszJakoMenuItem_Click(object sender, RoutedEventArgs e)
        {
            if (!string.IsNullOrEmpty(ścieżkaPliku))
            {
                saveFileDialog.InitialDirectory = Path.GetDirectoryName(ścieżkaPliku);
                saveFileDialog.FileName = Path.GetFileName(ścieżkaPliku);
            }

            bool? wynik = saveFileDialog.ShowDialog();
            if (wynik.HasValue && wynik.Value)
            {
                ścieżkaPliku = saveFileDialog.FileName;
                File.WriteAllText(ścieżkaPliku, textBox.Text);
                statusBarText.Text = Path.GetFileName(ścieżkaPliku);
                czyTekstZmieniony = false;
            }
        }

        private void ZapiszMenuItem_Click(object sender, RoutedEventArgs e)
        {
            if (!string.IsNullOrEmpty(ścieżkaPliku))
            {
                File.WriteAllText(ścieżkaPliku, textBox.Text);
                czyTekstZmieniony = false;
            }
            else ZapiszJakoMenuItem_Click(sender, e);
        }

        private void ZakończMenuItem_Click(object sender, RoutedEventArgs e)
        {
            Close();
        }

        private void textBox_TextChanged(object sender, TextChangedEventArgs e)
        {
            czyTekstZmieniony = true;
        }

        private void zapytajOZapisanieTekstuDoPliku(object sender, out bool anuluj)
        {
            anuluj = false;
            if (czyTekstZmieniony)
            {
                MessageBoxResult wynik =
                    MessageBox.Show(
                        "Czy zapisać zmiany w edytowanym dokumencie?",
                        this.Title,
                        MessageBoxButton.YesNoCancel,
                        MessageBoxImage.Question,
                        MessageBoxResult.Cancel);

                switch (wynik)
                {
                    case MessageBoxResult.Yes:
                        ZapiszMenuItem_Click(sender, null);
                        break;
                    case MessageBoxResult.No:
                        break;
                    case MessageBoxResult.Cancel:
                        anuluj = true;
                        break;
                }
            }
        }

        private void Window_Closing(object sender, System.ComponentModel.CancelEventArgs e)
        {
            bool anuluj;
            zapytajOZapisanieTekstuDoPliku(sender, out anuluj);
            e.Cancel = anuluj;
        }

        private void NowyMenuItem_Click(object sender, RoutedEventArgs e)
        {
            bool anuluj;
            zapytajOZapisanieTekstuDoPliku(sender, out anuluj);
            if (!anuluj) textBox.Text = "";
        }

        #endregion

        private void CofnijMenuItem_Click(object sender, RoutedEventArgs e)
        {
            textBox.Undo();
        }

        private void PowtórzMenuItem_Click(object sender, RoutedEventArgs e)
        {
            textBox.Redo();
        }

        private void WytnijMenuItem_Click(object sender, RoutedEventArgs e)
        {
            //string kopiowanyTekst = textBox.SelectedText;
            //Clipboard.SetText(kopiowanyTekst);
            //textBox.SelectedText = "";

            textBox.Cut();
        }

        private void KopiujMenuItem_Click(object sender, RoutedEventArgs e)
        {
            textBox.Copy();
        }

        private void WklejMenuItem_Click(object sender, RoutedEventArgs e)
        {
            textBox.Paste();
        }

        private void UsuńMenuItem_Click(object sender, RoutedEventArgs e)
        {
            textBox.SelectedText = "";
        }

        private void ZaznaczWszystkoMenuItem_Click(object sender, RoutedEventArgs e)
        {
            textBox.SelectAll();
        }

        private void GodzinaDataMenuItem_Click(object sender, RoutedEventArgs e)
        {
            textBox.SelectedText = DateTime.Now.ToString();
        }

        private void EdycjaMenuItem_SubmenuOpened(object sender, RoutedEventArgs e)
        {
            miCofnij.IsEnabled = textBox.CanUndo;
            miPowtórz.IsEnabled = textBox.CanRedo;
        }

        private void ZawijanieWierszyMenuItem_Click(object sender, RoutedEventArgs e)
        {
            textBox.TextWrapping = (sender as MenuItem).IsChecked ? TextWrapping.Wrap : TextWrapping.NoWrap;                
        }

        private void CzcionkaMenuItem_Click(object sender, RoutedEventArgs e)
        {
            Font czcionka = Font.ExtractFrom(textBox);
            if (WindowsFormsHelper.ChooseFont(ref czcionka)) czcionka.ApplyTo(textBox);
        }

        private void KolorTłaMenuItem_Click(object sender, RoutedEventArgs e)
        {
            Color kolorTła = Colors.White;
            if (textBox.Background is SolidColorBrush) kolorTła = (textBox.Background as SolidColorBrush).Color;
            //kolorTła = (textBox.Background as SolidColorBrush)?.Color;
            if (WindowsFormsHelper.ChooseColor(ref kolorTła))
                textBox.Background = new SolidColorBrush(kolorTła);
        }

        private Visibility bool2Visibility(bool b)
        {
            return b ? Visibility.Visible : Visibility.Collapsed;
        }

        private void PasekNarzędziMenuItem_Click(object sender, RoutedEventArgs e)
        {
            toolBar.Visibility = bool2Visibility((sender as MenuItem).IsChecked);
        }

        private void WstążkaMenuItem_Click(object sender, RoutedEventArgs e)
        {
            //ribbon.Visibility = bool2Visibility((sender as MenuItem).IsChecked);
        }

        private void PasekStanuMenuItem_Click(object sender, RoutedEventArgs e)
        {
            statusBar.Visibility = bool2Visibility((sender as MenuItem).IsChecked);
        }

        private void Window_PreviewKeyDown(object sender, KeyEventArgs e)
        {
            switch(e.Key)
            {
                case Key.F5: GodzinaDataMenuItem_Click(sender, null); break;
            }

            if((e.KeyboardDevice.Modifiers & ModifierKeys.Control) == ModifierKeys.Control)
            {
                switch(e.Key)
                {
                    case Key.N: NowyMenuItem_Click(sender, null); break;
                    case Key.O: OtwórzMenuItem_Click(sender, null); break;
                    case Key.S: ZapiszMenuItem_Click(sender, null); break;
                    case Key.P: DrukujMenuItem_Click(sender, null); break;
                }
            }
        }

        private void DrukujMenuItem_Click(object sender, RoutedEventArgs e)
        {
            Printing.PrintText(textBox.Text, Font.ExtractFrom(textBox));
        }

        private void MenuItem_ClickJezykPolski(object sender, RoutedEventArgs e)
        {
            //Nie działa!
            //System.Threading.Thread.CurrentThread.CurrentUICulture = new System.Globalization.CultureInfo("pl-PL");
            //InitializeComponent();
        }
    }
}
