﻿using System;

namespace AsystentZakupów.Model
{
    public class Sumator
    {
        public Sumator(decimal limit, decimal suma = 0)
        {
            this.limit = limit;
            this.Suma = suma;            
        }

        private decimal limit;
        public decimal Suma { get; private set; }        

        public bool CzyKwotaPoprawna(decimal kwota)
        {
            if (kwota <= 0) return false;
            if (Suma + kwota > limit) return false;
            return true;
        }

        public void Dodaj(decimal kwota)
        {
            if (CzyKwotaPoprawna(kwota)) Suma += kwota;
            else throw new ArgumentException("Kwota nie jest poprawna");
        }
    }
}
