﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Input;

namespace AsystentZakupów.ModelWidoku
{
    public class Sumowanie : INotifyPropertyChanged
    {

        private Model.Sumator model = new Model.Sumator(1000, 0);

        public decimal Suma
        {
            get
            {
                return model.Suma;
            }
        }

        private ICommand dodajCommand;

        public ICommand Dodaj
        {
            get
            {
                if (dodajCommand == null)
                    dodajCommand = new RelayCommand(
                        (object parametr) =>
                        {
                            decimal? kwota = (decimal?)parametr;
                            if (kwota.HasValue)
                            {
                                model.Dodaj(kwota.Value);
                                onPropertyChanged(nameof(Suma));
                            }
                        },
                        (object parametr) =>
                        {
                            decimal? kwota = (decimal?)parametr;
                            if (kwota.HasValue)
                            {
                                return model.CzyKwotaPoprawna(kwota.Value);
                            }
                            else return false;
                        });
                return dodajCommand;
            }
        }

        public event PropertyChangedEventHandler PropertyChanged;

        private void onPropertyChanged(string nazwaWłasności)
        {
            if (PropertyChanged != null)
                PropertyChanged(
                    this,
                    new PropertyChangedEventArgs(nazwaWłasności));
        }
    }
}
