﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;

using AsystentZakupów.Model;

namespace TestyJednostkowe
{
    [TestClass]
    public class TestyJednostkoweModelu
    {
        [TestMethod]
        public void TestKonstruktora()
        {
            //arrange            
            decimal suma = 1234;

            //act
            Sumator sumator = new Sumator(1000, suma);
            decimal _suma = sumator.Suma;

            //assert
            Assert.AreEqual(suma, _suma);
        }

        [TestMethod]
        public void TestMetodyDodaj()
        {
            //arrange            
            decimal suma = 123;
            decimal kwota = 567;

            //act
            Sumator sumator = new Sumator(1000, suma);
            sumator.Dodaj(kwota);
            decimal _suma = sumator.Suma;

            //assert
            Assert.AreEqual(suma + kwota, _suma);
        }

        [TestMethod]
        [ExpectedException(typeof(ArgumentException))]
        public void TestMetodyDodajWyjątek()
        {
            decimal suma = 123;

            //act
            Sumator sumator = new Sumator(1000, suma);
            sumator.Dodaj(-10);
        }

        [TestMethod]
        [ExpectedException(typeof(ArgumentException))]
        public void TestMetodyDodajWyjątek2()
        {
            decimal suma = 999;

            //act
            Sumator sumator = new Sumator(1000, suma);
            sumator.Dodaj(10);
        }

        [TestMethod]
        public void TestLimitu()
        {
            //arrange            
            decimal suma = 123;
            decimal limit = 567;

            //act
            Sumator sumator = new Sumator(limit, suma);
            PrivateObject po = new PrivateObject(sumator);
            decimal _limit = (decimal)po.GetField("limit");

            //assert
            Assert.AreEqual(limit, _limit);
        }

        [TestMethod]
        public void TestMetodyCzyKwotaPoprawna()
        {
            //arrange            
            decimal suma = 995;
            decimal limit = 1000;

            //act
            Sumator sumator = new Sumator(limit, suma);
            bool wynik0 = sumator.CzyKwotaPoprawna(2);
            bool wynik1 = sumator.CzyKwotaPoprawna(-10);
            bool wynik2 = sumator.CzyKwotaPoprawna(10);            

            Assert.IsTrue(wynik0, "czyKwotaPoprawna: 2");
            Assert.IsFalse(wynik1, "czyKwotaPoprawna: -10");
            Assert.IsFalse(wynik2, "czyKwotaPoprawna: 10");
        }
    }
}
