﻿using System;

namespace RównanieKwadratowe.Model
{
    public class EgzemplarzRównaniaKwadratowego
    {
        //public readonly double? X1, X2;

        //public double? X1 { get; private set; } //auto-implemented properties
        public double? X2 { get; private set; }

        private double? x1 = null;
        public double? X1
        {
            get
            {
                return x1;
            }
            private set
            {
                x1 = value;
            }
        }

        public EgzemplarzRównaniaKwadratowego(double a, double b, double c)
        {
            double delta = b * b - 4 * a * c;
            delta = Math.Sqrt(delta);
            X1 = null;
            X2 = null;
            if (delta >= 0)
            {
                X1 = (-b - delta) / (2 * a);
                X2 = (-b + delta) / (2 * a);
            }
        }
    }
}
