﻿using System;
using System.Windows;

namespace RównanieKwadratowe
{
    using Model;

    /// <summary>
    /// Logika interakcji dla klasy MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();
        }        

        class BrakRozwiązańException : Exception
        {
            public BrakRozwiązańException()
                :base("Brak rozwiązań równania")
            { }
        }

        private void Button_Click(object sender, RoutedEventArgs e)
        {
            try
            {
                double a = double.Parse(tbA.Text);
                double b = double.Parse(tbB.Text);
                double c = double.Parse(tbC.Text);
                EgzemplarzRównaniaKwadratowego erk = new EgzemplarzRównaniaKwadratowego(a, b, c);
                if (erk.X1 == null || erk.X2 == null) throw new BrakRozwiązańException();
                MessageBox.Show("X1=" + erk.X1 + ", X2=" + erk.X2);
            }
            catch(BrakRozwiązańException exc)
            {
                MessageBox.Show(exc.Message, Title, MessageBoxButton.OK, MessageBoxImage.Information);
            }
            catch(FormatException)
            {
                MessageBox.Show("Nieprawidłowe dane", Title, MessageBoxButton.OK, MessageBoxImage.Warning);
            }
            catch (Exception exc)
            {
                MessageBox.Show("Wystąpił błąd: " + exc.Message, Title, MessageBoxButton.OK, MessageBoxImage.Error);
            }
        }
    }
}
