﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;

using RównaniaKwadratowe.Model;

namespace TestyJednostkowe_Biblioteka
{
    [TestClass]
    public class UnitTest1
    {
        [TestMethod]
        public void TestyNormalnychPrzypadków()
        {
            EgzemplarzRównaniaKwadratowego erk1 = new EgzemplarzRównaniaKwadratowego(1, 2, 1);

            Assert.AreEqual(-1, erk1.X1, "1.x1");
            Assert.AreEqual(-1, erk1.X2, "1.x2");

            EgzemplarzRównaniaKwadratowego erk2 = new EgzemplarzRównaniaKwadratowego(1, 0, -1);

            Assert.AreEqual(-1, erk2.X1, "2.x1");
            Assert.AreEqual(1, erk2.X2, "2.x2");  
        }

        [TestMethod]
        [ExpectedException(typeof(RównaniaKwadratoweException),AllowDerivedTypes = false)]
        public void TestPrzypadkuNienormalnego()
        {
            EgzemplarzRównaniaKwadratowego erk = new EgzemplarzRównaniaKwadratowego(0, 1, 0);
        }

        [TestMethod]
        public void TestPrywatnegoPola()
        {
            EgzemplarzRównaniaKwadratowego erk = new EgzemplarzRównaniaKwadratowego(1, 0, -1);

            Assert.AreEqual(-1, erk.X1, "X1");

            PrivateObject po = new PrivateObject(erk);
            double? erk_x1 = (double?)po.GetField("x1");
            Assert.IsTrue(erk_x1.HasValue);
            Assert.AreEqual(-1, erk_x1.Value, "x1");
        }

        [TestMethod]
        public void TestZakresu()
        {
            const int N = 100;
            const double wymaganyZakres = 1000;
            Random r = new Random();

            for (int i = 0; i < N; ++i)
            {
                double a = r.NextDouble() * wymaganyZakres;
                double b = r.NextDouble() * wymaganyZakres;
                double c = r.NextDouble() * wymaganyZakres;

                EgzemplarzRównaniaKwadratowego erk = new EgzemplarzRównaniaKwadratowego(a, b, c);

                if (erk.X1.HasValue && double.IsInfinity(erk.X1.Value)) Assert.Fail();
                if (erk.X2.HasValue && double.IsInfinity(erk.X2.Value)) Assert.Fail();
            }
        }
    }
}
