﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using BibliotekaUlamek;

namespace UnitTestProject1
{
    [TestClass]
    public class UnitTest1
    {
        [TestMethod]
        public void TestKonstruktoraIWłasności()
        {
            Ulamek u = new Ulamek(1, 2);
            Assert.AreEqual(1, u.Licznik);
            Assert.AreEqual(2, u.Mianownik);
        }

        [TestMethod]
        public void TestKonstruktora()
        {
            Ulamek u = new Ulamek(1, 2);
            PrivateObject po = new PrivateObject(u);
            int licznik = (int)po.GetField("licznik");
            Assert.AreEqual(1, licznik);
            int mianownik = (int)po.GetField("mianownik");
            Assert.AreEqual(2, mianownik);
        }
        
        [TestMethod]
        public void TestUprość()
        {
            Ulamek u = new Ulamek(2, -4);
            u.Uprosc();
            Assert.AreEqual(-1, u.Licznik);
            Assert.AreEqual(2, u.Mianownik);

        }

        [TestMethod]
        public void TestUprość2()
        {
            Random r = new Random();
            for (int i=0; i<100; i++)
            {
                int l = r.Next();
                int m = r.Next();
                Ulamek u = new Ulamek(l, m);
                u.Uprosc();
                Assert.AreEqual(1.0*l/m, u.ToDouble());
                
            }

        }

    }
}
