﻿using System;

namespace AsystentZakupówMVVM.Model
{
    public class Model
    {
        private decimal suma = 0;
        private decimal limit = 0;

        public decimal Suma
        {
            get
            {
                return suma;
            }
        }

        public Model(decimal limit, decimal sumaPoczątkowa = 0)
        {
            this.limit = limit;
            this.suma = sumaPoczątkowa;
        }

        public bool SprawdźKwotę(decimal kwota)
        {
            return kwota > 0 && suma + kwota <= limit;
        }

        public void Dodaj(decimal kwota)
        {
            if (!SprawdźKwotę(kwota)) throw new Exception("Kwota nie jest prawidłowa");
            else suma += kwota;
        }
    }
}
