﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Input;
using System.ComponentModel;

namespace AsystentZakupówMVVM.ModelWidoku
{
    using Model;    

    public class ModelWidoku : INotifyPropertyChanged
    {
        private Model model = new Model(1000, 0);

        public decimal Suma
        {
            get
            {
                return model.Suma;
            }
        }

        bool ustalKwotę(object parametr, out decimal kwota)
        {
            try
            {
                if (string.IsNullOrWhiteSpace(parametr as string)) throw new Exception("Parametr jest złego typu lub pusty");
                if (!decimal.TryParse(parametr as string, out kwota)) throw new Exception("Łańcuch parametru nie zawiera liczby (" + parametr + ")");
                return true;
            }
            catch
            {
                kwota = 0M;
                return false;
            }
        }


        private ICommand dodajKwotęCommand = null;        

        public ICommand DodajKwotę
        {
            get
            {
                if (dodajKwotęCommand == null)
                    dodajKwotęCommand = new RelayCommand(
                        (object parametr) =>
                        {
                            decimal kwota;
                            ustalKwotę(parametr, out kwota);
                            model.Dodaj(kwota);
                            OnPropertyChanged(nameof(Suma));
                        },
                        (object parametr) =>
                        {
                            decimal kwota;
                            return ustalKwotę(parametr, out kwota) && model.SprawdźKwotę(kwota);
                        });
                return dodajKwotęCommand;
            }
        }

        public event PropertyChangedEventHandler PropertyChanged;

        private void OnPropertyChanged(string nazwaWłasności)
        {
            if (PropertyChanged != null)
                PropertyChanged(this, new PropertyChangedEventArgs(nazwaWłasności));
        }
    }
}
