﻿using System;
using Windows.UI.Xaml.Data;
using Windows.UI.Xaml.Media;

namespace KoloryUWP
{
    using KoloryMVVM.ModelWidoku;
    using Windows.UI;

    class ByteToDouble : IValueConverter
    {
        public object Convert(object value, Type targetType, object parameter, string language)
        {
            byte b = (byte)value;
            double d = (double)b;
            return d;
        }

        public object ConvertBack(object value, Type targetType, object parameter, string language)
        {
            double d = (double)value;
            byte b = (byte)d;
            return b;
        }
    }

    class ModelWidokuToBrush : IValueConverter
    {
        public object Convert(object value, Type targetType, object parameter, string language)
        {
            KlasaModeluWidoku mw = (KlasaModeluWidoku)value;
            Color color = Color.FromArgb(255, mw.R, mw.G, mw.B);
            return new SolidColorBrush(color);
        }

        public object ConvertBack(object value, Type targetType, object parameter, string language)
        {
            throw new NotImplementedException();
        }
    }

    class ModelWidokuToString : IValueConverter
    {
        public object Convert(object value, Type targetType, object parameter, string language)
        {
            KlasaModeluWidoku mw = (KlasaModeluWidoku)value;
            return "Kolor: #" + mw.R.ToString("X2") + mw.G.ToString("X2") + mw.B.ToString("X2");
        }

        public object ConvertBack(object value, Type targetType, object parameter, string language)
        {
            throw new NotImplementedException();
        }
    }
}
