﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Input;

namespace KoloryMVVM.ModelWidoku
{
    class KlasaModeluWidoku : INotifyPropertyChanged
    {
        private Model.Kolor instancjaKolor = new Model.Kolor() { R = 0, G = 0, B = 0 };

        #region Własności
        public byte R
        {
            get
            {
                return instancjaKolor.R;
            }
            set
            {
                instancjaKolor.R = value;
                onPropertyChanged(nameof(R));
                onPropertyChanged(nameof(This));
                //reset.WywołajZdarzenie(null);
            }
        }

        public byte G
        {
            get
            {
                return instancjaKolor.G;
            }
            set
            {
                instancjaKolor.G = value;
                onPropertyChanged(nameof(G));
                onPropertyChanged(nameof(This));
                //reset.WywołajZdarzenie(null);
            }
        }

        public byte B
        {
            get
            {
                return instancjaKolor.B;

            }
            set
            {
                instancjaKolor.B = value;
                onPropertyChanged(nameof(B));
                onPropertyChanged(nameof(This));
                //reset.WywołajZdarzenie(null);
            }
        }

        public KlasaModeluWidoku This
        {
            get
            {
                return this;
            }
        }
        #endregion

        #region Polecenie
        private void resetuj()
        {
            R = 0;
            G = 0;
            B = 0;
        }

        private RelayCommand reset;

        public ICommand Reset
        {
            get
            {
                if (reset == null) reset = new RelayCommand(
                     (object parametr) => { resetuj(); },
                     (object parametr) => { return R != 0 || G != 0 || B != 0; });
                return reset;
            }
        }
        #endregion

        #region INotifyPropertyChanged
        public event PropertyChangedEventHandler PropertyChanged;

        void onPropertyChanged(string nazwaWłasności)
        {
            if (PropertyChanged != null) PropertyChanged(this, new PropertyChangedEventArgs(nazwaWłasności));
        }
        #endregion
    }
}
