﻿using System;
using System.Threading;
using System.Windows.Input;

public class RelayCommand : ICommand
{
    private Action<object> execute;
    private Func<object, bool> canExecute;

    public event EventHandler CanExecuteChanged;

    private bool poprzedniaWartośćCanExecute = false;

    public void WywołajZdarzenie(object parametr)
    {
        bool bieżącaWartośćCanExecute = CanExecute(parametr);
        if(bieżącaWartośćCanExecute != poprzedniaWartośćCanExecute && CanExecuteChanged != null)
            CanExecuteChanged(this, EventArgs.Empty);
        poprzedniaWartośćCanExecute = bieżącaWartośćCanExecute;
    }

    /*
    public event EventHandler CanExecuteChanged
    {
        add { CommandManager.RequerySuggested += value; }
        remove { CommandManager.RequerySuggested -= value; }
    }
    */

    public RelayCommand(Action<object> execute, Func<object, bool> canExecute = null)
    {
        Timer t = new Timer(WywołajZdarzenie, null, 0, 100);

        if (execute == null) throw new ArgumentNullException(nameof(execute));
        this.execute = execute;
        this.canExecute = canExecute;
    }

    public bool CanExecute(object parameter)
    {
        if (canExecute == null) return true;
        else return canExecute(parameter);
    }

    public void Execute(object parameter)
    {
        execute(parameter);
    }
}
