﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Media;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Mikolaj
{
    public partial class Form1 : Form
    {
        private Bitmap _mikolajBitmap; // zaladowany mikolaj.gif
        private int _mikolajWysokosc; // docelowa wysokosc mikolaja
        private int _mikolajSzerokosc; // docelowa szerokosc mikolaja
        private Color _kolorTlaMikolaja = Color.FromArgb(229, 229, 229); // kolor tla mikolaja do wyciecia (aby byl przezroczysty0
        private Timer _timer; // czasomierz dla biegu mikolaja
        private bool _biegwPrawo = true; // czy biegnie w prawo
        private Rectangle _mikolajPostac = new Rectangle(220, 20, 325, 545); // wymiary wycietego oryginalnego mikolaja z mikolaj.gif
        private SoundPlayer _hoHoHo = new SoundPlayer("ho-ho-ho.wav"); // plik dzwiekowy

        public Form1()
        {
            InitializeComponent();

            this.SetStyle(ControlStyles.UserPaint | ControlStyles.OptimizedDoubleBuffer |
                ControlStyles.AllPaintingInWmPaint | ControlStyles.SupportsTransparentBackColor,
                true); // przeciwdziala "miganiu" animacji mikolaja

            _mikolajBitmap = new Bitmap("mikolaj.gif");
            _mikolajWysokosc = _mikolajPostac.Height / 2; // mikolaj ma byc o polowe mniejszy niz oryginalny gif
            _mikolajSzerokosc = _mikolajPostac.Width / 2;
            ImageAnimator.Animate(_mikolajBitmap, DrawFrame); // uruchomienie animacji gif

            Bounds = new Rectangle(0, 0, _mikolajSzerokosc, _mikolajWysokosc); // dopasowanie wielkoksci okna do mikolaja

            _timer = new Timer(); 
            _timer.Interval = 30; // ~30 fps
            _timer.Tick += OnTick; 
            _timer.Start(); // odpalenie czasomierza
        }

        private void OnTick(object sender, EventArgs e)
        {
            
            if (_biegwPrawo)
            {
                if (Left + _mikolajSzerokosc >= Screen.PrimaryScreen.Bounds.Width) // spradzenie czy dotarl do prawej krawedzi ekranu
                {
                    _biegwPrawo = false;
                }
                else
                {
                    Left += 3; // empirycznie wyznaczona predkosc mikolaja
                }
            }
            else
            {
                if (Left <= 0) // sprawdzenie czy dotarl do lewej krawedzi ekranu
                {
                    _biegwPrawo = true;
                }
                else
                {
                    Left -= 3;
                }
            }
        }

        private void DrawFrame(object sender, EventArgs e)
        {
            this.Invalidate();
        }

        private void Form1_Paint(object sender, PaintEventArgs e)
        {
            ImageAnimator.UpdateFrames(_mikolajBitmap); // ustawienie aktualnej klatki w mikolaj.gif

            using (Bitmap bmp = new Bitmap(_mikolajSzerokosc, _mikolajWysokosc)) // utworzenie tymczasowej bitmapy na ktorej przerysujemy klatke mikolaja.gif
            {
                using (Graphics gr = Graphics.FromImage(bmp))
                {
                    // przerysowanie fragmentu mikolaja i jego przeskalowaine
                    gr.DrawImage(_mikolajBitmap, new Rectangle(0, 0, _mikolajSzerokosc, _mikolajWysokosc), _mikolajPostac.X, _mikolajPostac.Y, _mikolajPostac.Width, _mikolajPostac.Height, GraphicsUnit.Pixel);
                }
                if (!_biegwPrawo)
                {
                    bmp.RotateFlip(RotateFlipType.RotateNoneFlipX); // ewentualne obrocenie go na lewo
                }
                bmp.MakeTransparent(_kolorTlaMikolaja); // ustawienie tla z gifa co by bylo traktowane jako przezroczyste
                e.Graphics.DrawImage(bmp, 0, 0); // narysowanie tymczasowej bitmapy z przeskalowanym mikolajem na formatce
            }
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            Top = Screen.PrimaryScreen.Bounds.Bottom - 50 - _mikolajWysokosc; // ustawienie mikolaja nad paskiem
        }

        private void Form1_Click(object sender, EventArgs e)
        {
            _hoHoHo.Play(); // dzwiek ho ho ho na klikniecie
        }
    }
}
