﻿using System;
using System.IO;
using System.Collections.Generic;

namespace Turing
{
    class TuringException : Exception
    {
        public TuringException(string message = "", Exception innerException = null)
            :base(message, innerException)
        { }
    }

    public class Program
    {
        #region Łańcuch opisującym stan maszyny
        //public tylko ze względu na testy jednostkowe
        public static (char[] taśma, char stanGłowicy, int położenieGłowicy) analizujOpisStanuMaszyny(string łańcuchOpisującyStanMaszyny)
        {
            char początkowyStanGłowicy = ' ';
            int początkowePołożenieGłowicy = -1;
            string łańcuchTaśmy = "";
            for(int i = 0; i < łańcuchOpisującyStanMaszyny.Length; ++i)
            {
                char c = łańcuchOpisującyStanMaszyny[i];
                if (c == 'L' || c == 'R')
                    throw new TuringException("Litery L i R nie są dozwolone na taśmie");
                if(char.IsLower(c))
                {
                    if (początkowePołożenieGłowicy != -1)
                        throw new TuringException("Znaleziono więcej niż jeden znak oznaczający głowicę");
                    początkowyStanGłowicy = c;
                    początkowePołożenieGłowicy = i;
                    łańcuchTaśmy = łańcuchOpisującyStanMaszyny.Remove(i, 1);
                }
                else
                {
                    if (c < 'A' || c > 'Z')
                        throw new TuringException($"Niepoprawna wartość na taśmie {c} na pozycji {i}");
                }
            }
            if (początkowePołożenieGłowicy < 0)
                throw new TuringException("Nie znaleziono znaku oznaczającego głowicę");
            return (łańcuchTaśmy.ToCharArray(), początkowyStanGłowicy, początkowePołożenieGłowicy);
        }

        //public tylko ze względu na testy jednostkowe
        public static string pobierzŁańcuchOznaczającyStanMaszyny(
            (char[] taśma, char stanGłowicy, int położenieGłowicy) stanMaszyny)
        {
            string s = new string(stanMaszyny.taśma);
            s = s.Insert(stanMaszyny.położenieGłowicy, stanMaszyny.stanGłowicy.ToString());
            return s;
        }
        #endregion

        #region Parsowanie kodu programu
        static bool czyCzwórkaJestPoprawna(string linia)
        {
            Func<char, bool> isLower = (char c) => c >= 'a' && c <= 'z';
            Func<char, bool> isUpper = (char c) => c >= 'A' && c <= 'Z';

            if (linia.Length != 4) throw new TuringException("Nieodpowiednia liczba znaków w czwórce");
            //if (isLower(linia[0]) && isUpper(linia[1]) && isUpper(linia[2]) && isLower(linia[3])) return true;
            //else return false;
            //return (isLower(linia[0]) && isUpper(linia[1]) && isUpper(linia[2]) && isLower(linia[3])) ? true : false;
            return isLower(linia[0]) && isUpper(linia[1]) && isUpper(linia[2]) && isLower(linia[3]);
        }

        static SortedList<(char, char),(char, char)> parsujProgram(string[] kodProgramu)
        {
            SortedList<(char, char), (char, char)> czwórki = new SortedList<(char, char), (char, char)>(kodProgramu.Length);
            foreach(string linia in kodProgramu)
            {
                if (string.IsNullOrWhiteSpace(linia)) continue;
                if (!czyCzwórkaJestPoprawna(linia)) throw new TuringException($"Niepoprawna linia kodu: {linia}");
                (char, char) stanBieżący = (linia[0], linia[1]);
                (char, char) nowyStan = (linia[3], linia[2]);
                if (czwórki.ContainsKey(stanBieżący)) throw new TuringException("Program nie może zawierać dwóch linii z tymi samymi dwoma literami");
                czwórki.Add(stanBieżący, nowyStan);
            }
            return czwórki;
        }
        #endregion

        static void Main(string[] args)
        {
            string[] kodProgramu = File.ReadAllLines("program.txt");
            string łańcuchOpisującyStanMaszyny = File.ReadAllText("taśma.txt");

            Console.WriteLine("Początkowy stan maszyny: " + łańcuchOpisującyStanMaszyny);
            Console.WriteLine("Program: ");
            foreach (string linia in kodProgramu) Console.WriteLine(linia);

            try
            {
                var stanMaszyny = analizujOpisStanuMaszyny(łańcuchOpisującyStanMaszyny);
                Console.WriteLine("Stan głowicy: " + stanMaszyny.stanGłowicy);
                Console.WriteLine("Położenie głowicy: " + stanMaszyny.położenieGłowicy);
                Console.WriteLine("Taśma: " + new string(stanMaszyny.taśma));

                SortedList<(char, char), (char, char)> program = parsujProgram(kodProgramu);
                foreach(KeyValuePair<(char, char), (char, char)> polecenie in program)
                {
                    Console.WriteLine(polecenie.ToString());
                }
            }
            catch(TuringException exc)
            {
                Console.Error.WriteLine("Błąd maszyny Turinga: " + exc.Message);
            }
            catch(Exception exc)
            {
                Console.Error.WriteLine("Nierozpoznany błąd: " + exc.Message);
            }
        }
    }
}
