﻿using System;
using System.IO;
using System.Collections.Generic;

namespace TuringDemo
{
    public class Program
    {
        static List<string> wykonajProgram(
            (char[] taśma, char stanGłowicy, int położenieGłowicy) stanMaszyny,
            Czwórki program)
        {
            List<string> wyjście = new List<string>();
            (char nowyStanGłowicy, char nowaWartośćLubPolecenie)? polecenie;
            while (
                (polecenie = znajdźPolecenie(
                    stanMaszyny.stanGłowicy,
                    stanMaszyny.taśma[stanMaszyny.położenieGłowicy],
                    program)) != null)
            {
                stanMaszyny.stanGłowicy = polecenie.Value.nowyStanGłowicy;
                switch(polecenie.Value.nowaWartośćLubPolecenie)
                {
                    case 'L':
                        stanMaszyny.położenieGłowicy--;
                        break;
                    case 'R':
                        stanMaszyny.położenieGłowicy++;
                        break;
                    default:
                        stanMaszyny.taśma[stanMaszyny.położenieGłowicy] = polecenie.Value.nowaWartośćLubPolecenie;
                        break;
                }
                wyjście.Add(pobierzŁańcuchOznaczającyStanMaszyny(stanMaszyny));
                //Console.WriteLine(pobierzŁańcuchOznaczającyStanMaszyny(stanMaszyny));
            }
            return wyjście;
        }

        static void Main(string[] args)
        {
            if(args.Length < 2)
            {
                Console.Error.WriteLine("Składnia: Turing program.txt taśma.txt");
                return;
            }

            string ścieżkaPlikuProgramu = args[0];
            if(!File.Exists(ścieżkaPlikuProgramu))
            {
                Console.Error.WriteLine($"Brak pliku programu {ścieżkaPlikuProgramu}");
                return;
            }

            string ścieżkaPlikuTaśmy = args[1];
            if(!File.Exists(ścieżkaPlikuTaśmy))
            {
                Console.Error.WriteLine($"Brak pliku taśmy {ścieżkaPlikuTaśmy}");
                return;
            }

            string[] kodProgramu = File.ReadAllLines(ścieżkaPlikuProgramu);
            string łańcuchOpisującyStanMaszyny = File.ReadAllText(ścieżkaPlikuTaśmy);

            Console.WriteLine("Początkowy stan maszyny: " + łańcuchOpisującyStanMaszyny);
            Console.WriteLine("Program: ");
            foreach (string linia in kodProgramu) Console.WriteLine(linia);

            try
            {
                var stanMaszyny = analizujOpisStanuMaszyny(łańcuchOpisującyStanMaszyny);
                Console.WriteLine("Stan głowicy: " + stanMaszyny.stanGłowicy);
                Console.WriteLine("Położenie głowicy: " + stanMaszyny.położenieGłowicy);
                Console.WriteLine("Taśma: " + new string(stanMaszyny.taśma));

                Czwórki program = parsujProgram(kodProgramu);
                foreach(KeyValuePair<(char, char), (char, char)> polecenie in program)
                {
                    Console.WriteLine(polecenie.ToString());
                }

                Console.WriteLine("Uruchomienie programu...");
                Console.WriteLine(pobierzŁańcuchOznaczającyStanMaszyny(stanMaszyny));
                List<string> wyjście = wykonajProgram(stanMaszyny, program);

                foreach (string liniaWyjścia in wyjście) Console.WriteLine(liniaWyjścia);
            }
            catch(TuringException exc)
            {
                Console.Error.WriteLine("Błąd maszyny Turinga: " + exc.Message);
            }
            catch(Exception exc)
            {
                Console.Error.WriteLine("Nierozpoznany błąd: " + exc.Message);
            }
        }
    }
}
