﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Linq;

namespace AplikacjaKonsolowa
{
    //więcej niż POCO

    public class SettingsException : Exception
    {
        public SettingsException(string message = null, Exception innerException = null)
            : base(message, innerException)
        {
        }
    }

    public class SettingsManager<T>
        where T : class, new()
    {
        private Dictionary<string, object> values;
        private string path;
        private IFormatProvider formatProvider = new CultureInfo("pl-PL");

        private SettingsManager(Dictionary<string, object> values, string path, IFormatProvider formatProvider = null)
        {
            if (formatProvider == null) this.formatProvider = new CultureInfo("pl-PL");
            else this.formatProvider = formatProvider;
            this.values = values;
            this.path = path;
        }

        public SettingsManager(T settingsObject, string path, IFormatProvider formatProvider = null)
            : this(extractValues(settingsObject), path, formatProvider)
        {
        }

        private static Dictionary<string, object> extractValues(T settingsObject)
        {
            if (settingsObject != null)
            {
                Dictionary<string, object> values = new Dictionary<string, object>();
                //Reflection!

                Type settingsObjectType = typeof(T);
                FieldInfo[] fields = settingsObjectType.GetFields(BindingFlags.NonPublic | BindingFlags.Instance | BindingFlags.Public);
                foreach (FieldInfo field in fields)
                {
                    object value = field.GetValue(settingsObject);
                    string name = field.Name;
                    values.Add(name, value);
                }

                /*
                PropertyInfo[] properties = settingsObjectType.GetProperties();
                foreach (PropertyInfo property in properties)
                {
                    object value = property.GetValue(settingsObject);
                    string name = property.Name;
                    values.Add(name, value);
                }
                */

                return values;
            }
            else
            {
                throw new SettingsException("No values in settings object");
            }
        }

        private static void saveToXmlFile(Dictionary<string, object> values, string path, IFormatProvider formatProvider)
        {
            //LINQ to XML
            XElement[] xElements = (from KeyValuePair<string, object> value in values
                                    orderby value.Key
                                    select new XElement("setting",
                                        new XAttribute("Name", value.Key),
                                        new XAttribute("Type", value.Value.GetType().Name),
                                        Convert.ToString(value.Value, formatProvider))).ToArray();
            XDocument xml = new XDocument(
                new XDeclaration("1.0", "utf-8", "yes"),
                new XElement("settings",
                    xElements));
            xml.Save(path);
        }

        public void Save()
        {
            try
            {
                saveToXmlFile(values, path, formatProvider);
            }
            catch (Exception exc)
            {
                throw new SettingsException("Błąd podczas zapisu do pliku", exc);
            }
        }
    }
}
