﻿using System;

//Console.WriteLine("Witaj Świecie!");

namespace CS9
{
    public record Osoba(string Imię, string Nazwisko)
    {
        //public string Imię { get; init; }
        //public string Nazwisko { get; init; }
        public int NumerTelefonu { get; set; }

        /*
        public Osoba(string imię, string nazwisko)
        {
            Imię = imię;
            Nazwisko = nazwisko;
        }
        */

        public override string ToString()
        {
            return $"{Imię} {Nazwisko}, nr tel. {NumerTelefonu}";
        }

        /*
        public override bool Equals(object? obj)
        {
            Osoba o = (Osoba)obj;
            return this.Imię.Equals(o.Imię) && this.Nazwisko.Equals(o.Nazwisko);
        }
        */
    }

    public record Student : Osoba
    {
        public int NumerLegitymacji { get; init; }

        public Student(string imię, string nazwisko, int numerLegitymacji)
            :base(imię, nazwisko)
        {
            NumerLegitymacji = numerLegitymacji;
        }

    }

    class Program
    {
        static void Main_Rekordy(string[] args)
        {
            Osoba o = new Osoba("Henryk", "Garncarz") { NumerTelefonu = 1234566 };
            Console.WriteLine(o);

            /*
            Osoba p = new Osoba()
            {
                Imię = "Henryk",
                Nazwisko = "Garncarz",
                NumerTelefonu = 1234566
            };
            */
            Osoba p = new Osoba("Henryk", "Garncarz") { NumerTelefonu = 1234566 };
            //Osoba p = o with { Imię = "Witold" };
            //Osoba p = o with { };
            Console.WriteLine(p);

            Console.WriteLine(o == p);
            Console.WriteLine(o.Equals(p));
        }

        static void Main(string[] args)
        {
            for (int i = 0; i < 10; i++)
            {
                /*
                Random r = new Random();
                int n = r.Next(8);
                string opis;
                switch (n)
                {
                    case 1 or 7:
                        opis = "weekend";
                        break;
                    case 2 or 3 or 4 or 5 or 6:
                        opis = "dzień roboczy";
                        break;
                    default:
                        opis = "błąd!";
                        break;
                }
                Console.WriteLine($"Typ dnia: {n}, {opis}");
                */

                Random r = new Random();
                int n = r.Next(8);
                string opis = n switch
                {
                    1 or 7 => "weekend",
                    >= 2 and <= 6 => "dzień roboczy",
                    _ => "błąd!"
                };
                Console.WriteLine($"Typ dnia: {n}, {opis}");

                if (opis is not string) Console.WriteLine("Coś!");
            }
        }
    }
}