﻿using System;

namespace Turing
{
    public class Program
    {
        #region Stan maszyny
        public static (char[] taśma, char stanGłowicy, int położenieGłowicy) AnalizujOpisStanuMaszyny(string łańcuchOpisującyStanMaszyny)
        {
            char? początkowyStanGłowicy = null;
            int początkowePołożenieGłowicy = -1;
            for (int i = 0; i < łańcuchOpisującyStanMaszyny.Length; i++)
            {
                char c = łańcuchOpisującyStanMaszyny[i];
                if (c == 'L' || c == 'R')
                    throw new Exception("Taśma nie może zawierać poleceń L i R");
                if (char.IsLower(c))
                {
                    if (początkowyStanGłowicy.HasValue)
                        throw new Exception("Opis stanu maszyny nie może zawierać dwóch głowic");
                    początkowyStanGłowicy = c;
                    początkowePołożenieGłowicy = i;
                    łańcuchOpisującyStanMaszyny = łańcuchOpisującyStanMaszyny.Remove(początkowePołożenieGłowicy, 1);
                }
                else
                {
                    if (c < 'A' || c > 'Z') throw new Exception("Niedozwolone znaki na taśmie");
                }
            }
            if (!początkowyStanGłowicy.HasValue || początkowePołożenieGłowicy == -1)
                throw new Exception("Opis stanu maszyny nie zawiera głowicy");
            return (łańcuchOpisującyStanMaszyny.ToCharArray(), początkowyStanGłowicy.Value, początkowePołożenieGłowicy);
        }

        public static string TwórzŁańcuchOpisującyStanMaszyny(char[] taśma, char stanGłowicy, int położenieGłowicy)
        {
            string s = new string(taśma);
            s = s.Insert(położenieGłowicy, stanGłowicy.ToString());
            return s;            
        }
        #endregion

        #region Program
        class LiniaProgramu
        {
            char początkowyStanGłowicy, końcowyStanGłowicy;
            char początkowyStanKomórki, końcowyStanKomórki;

            public override string ToString()
            {
                return $"{początkowyStanGłowicy}{początkowyStanKomórki}{końcowyStanKomórki}{końcowyStanGłowicy}";
            }

            //TODO: określić obiekt-parę głowica+komórka
            public LiniaProgramu(char początkowyStanGłowicy, char początkowyStanKomórki, char końcowyStanKomórki, char końcowyStanGłowicy)
            {
                if (!char.IsLower(początkowyStanGłowicy)) throw new Exception("Stan głowicy powinien być zapisany małą literą");
                if (char.IsLower(początkowyStanKomórki)) throw new Exception("Stan komórki powinien być zapisany małą literą");
                if(początkowyStanKomórki == 'R' || początkowyStanKomórki == 'L') throw new Exception("Początkowy stan komórki nie może być R lub L");
                //TODO: uzupełnić weryfikację np. o znaki spoza A-Z
                if (char.IsLower(końcowyStanKomórki)) throw new Exception("Stan komórki powinien być zapisany małą literą");
                if (!char.IsLower(końcowyStanGłowicy)) throw new Exception("Stan głowicy powinien być zapisany małą literą");
                this.początkowyStanGłowicy = początkowyStanGłowicy;
                this.początkowyStanKomórki = początkowyStanKomórki;
                this.końcowyStanKomórki = końcowyStanKomórki;
                this.końcowyStanGłowicy = końcowyStanGłowicy;
            }

            /*
            //niezadawalające rozwiązanie
            public LiniaProgramu(string linia)
                //:this(linia[0], linia[1], linia[2], linia[3])
            {
                if (linia.Length != 4) throw new Exception("Linia programu musi mieć 4 znaki");
                new LiniaProgramu(linia[0], linia[1], linia[2], linia[3]);
            }
            */

            public LiniaProgramu ParsujLinię(string linia)
            {
                if (linia.Length != 4) throw new Exception("Linia programu musi mieć 4 znaki");
                return new LiniaProgramu(linia[0], linia[1], linia[2], linia[3]);
            }
        }

        class ProgramTuring
        {
            public LiniaProgramu[] LinieProgramu;
        }
        #endregion

        #region Wczytywanie z pliku
        public static string WczytajOpisującyStanMaszynyZPliku(string ścieżkaPliku)
        {
            string s = System.IO.File.ReadAllText(ścieżkaPliku);
            return s;
        }

        public static string[] WczytajProgramZPliku(string ścieżkaPliku)
        {
            string[] linie = System.IO.File.ReadAllLines(ścieżkaPliku);
            return linie;
        }
        #endregion

        static void Main(string[] args)
        {
            string[] linieProgramu = WczytajProgramZPliku("program.txt");
            Program ***
        }
    }
}
