using Microsoft.VisualStudio.TestTools.UnitTesting;
using Turing;

namespace TestyJednostkowe
{
    [TestClass]
    public class TestTuringa
    {
        [TestMethod]
        public void TestTworzeniaOpisu()
        {            
            string s = Program.TwrzacuchOpisujcyStanMaszyny(new char[] { 'U', 'M', 'K' }, 'a', 1);
            Assert.AreEqual("UaMK", s);
        }

        [TestMethod]
        public void TestParsowaniaOpisu()
        {
            //arrange
            char[] ca = "UMK".ToCharArray();

            //act
            var wynik = Program.AnalizujOpisStanuMaszyny("UaMK");

            //assert
            Assert.AreEqual("UMK", new string(wynik.tama));
            //Assert.AreEqual(ca, wynik.tama);
            Assert.AreEqual(1, wynik.pooenieGowicy);
            Assert.AreEqual('a', wynik.stanGowicy);
        }

        [TestMethod]
        public void TestAnalizyIParsowaniaOpisu()
        {
            string s = "UaMK";
            var wynik = Program.AnalizujOpisStanuMaszyny(s);
            string s1 = Program.TwrzacuchOpisujcyStanMaszyny(wynik.tama, wynik.stanGowicy, wynik.pooenieGowicy);
            Assert.AreEqual(s, s1);
        }

        [TestMethod]
        [ExpectedException(typeof(System.Exception))]
        public void TestParsowaniaOpisuBd1()
        {
            var wynik = Program.AnalizujOpisStanuMaszyny("UMK");
        }

        [TestMethod]
        [ExpectedException(typeof(System.Exception))]
        public void TestParsowaniaOpisuBd2()
        {
            var wynik = Program.AnalizujOpisStanuMaszyny("aUbMK");
        }

        [TestMethod]
        [ExpectedException(typeof(System.Exception))]
        public void TestParsowaniaOpisuBd3()
        {
            var wynik = Program.AnalizujOpisStanuMaszyny("UaMK$");
        }
    }
}
