﻿using System;

using DocumentFormat.OpenXml;
using DocumentFormat.OpenXml.Wordprocessing;

namespace WordLibrary
{
    public static class FormatowaniaDocx
    {
        private const int rozmiarCzcionkiNormalny = 21;
        private const int rozmiarCzcionkiTytułu = 48;
        private const string kształtCzcionki = "Arial";

        public static Color KolorWyróżniony
        {
            get
            {
                return new Color() { Val = "203ABF" };
            }
        }

        public static Color KolorNormalny
        {
            get
            {
                return new Color() { Val = "Black" };
            }
        }

        public static RunFonts CzcionkaNormalna
        {
            get
            {
                return new RunFonts()
                {
                    Ascii = kształtCzcionki,
                    HighAnsi = kształtCzcionki
                };
            }
        }

        public static RunProperties StylUstępNormalny
        {
            get
            {
                return new RunProperties()
                {
                    RunFonts = CzcionkaNormalna,
                    FontSize = new FontSize()
                    {
                        Val = new StringValue(rozmiarCzcionkiNormalny.ToString())
                    },
                    Color = KolorNormalny
                };
            }
        }

        public static RunProperties StylUstępuTytułu
        {
            get
            {
                return new RunProperties()
                {
                    Bold = new Bold()
                    {
                        Val = OnOffValue.FromBoolean(true)
                    },
                    FontSize = new FontSize()
                    {
                        Val = new StringValue(rozmiarCzcionkiTytułu.ToString())
                    },
                    RunFonts = CzcionkaNormalna,
                    Color = KolorWyróżniony
                };
            }
        }

        //zwiększona interlinia
        public static ParagraphProperties UstawieniaAkapitu
        {
            get
            {
                ParagraphProperties paragraphProperties = new ParagraphProperties();
                paragraphProperties.Append(new SpacingBetweenLines() { Line = "360" });
                return paragraphProperties;
            }
        }
    }
}
