﻿using EF.BazaDanych;

namespace EF
{
    using static System.Console;

    class Program
    {
        static void podglądBazyDanych(BazaDanychOsób db)
        {
#if DEBUG
            try
            {
                WriteLine("\nPodgląd danych:");
                WriteLine("Osoby:");
                foreach (Osoba osoba in db.Osoby)
                    WriteLine(osoba);
                WriteLine("Adresy:");
                foreach(Adres adres in db.Adresy)
                    WriteLine(adres);
            }
            catch(Exception exc)
            {
                Error.WriteLine($"Błąd podglądu bazy danych: {exc.Message}");
            }
#else
            WriteLine("Dostęp do bazy tylko w trybie debugowania");
            #endif
        }

        static void dodajPrzykładoweOsoby(BazaDanychOsób db)
        {
            Adres adres1 = new Adres()
            {
                Miasto = "Toruń",
                Ulica = "Pod Mostem",
                NumerDomu = 1
            };

            Adres adres2 = new Adres()
            {
                Miasto = "Toruń",
                Ulica = "Gałczyńskiego",
                NumerDomu = 5,
                NumerMieszkania = 34
            };

            Osoba osoba1 = new Osoba()
            {
                Imię = "Antoni",
                Nazwisko = "Kałamaż",
                NumerTelefonu = 724728399,
                Adres = adres1
            };

            Osoba osoba2 = new Osoba()
            {
                Imię = "Wincenty",
                Nazwisko = "Pióro",
                NumerTelefonu = 12927927,
                Adres = adres2
            };

            Osoba osoba3 = new Osoba()
            {
                Imię = "Karol",
                Nazwisko = "Atrament",
                NumerTelefonu = 283429874,
                Adres = adres1
            };

            db.DodajOsobę(osoba1);
            db.DodajOsobę(osoba2);
            db.DodajOsobę(osoba3);
        }

        static void Main(string[] args)
        {
            string dbName = "osoby.db";

            //WriteLine("Usuwam plik bazy danych...");
            //if(File.Exists(dbName)) File.Delete(dbName);

            BazaDanychOsób db = new BazaDanychOsób();            

            //dodajPrzykładoweOsoby(db);
            podglądBazyDanych(db); //TODO: Tu nie pojawiają się adresy!!
            //podglądBazyDanych(db);

            db.UsuńOsobę(2);
            podglądBazyDanych(db);

            db.AktualizujOsobę(4, new Osoba { Id = 5, Imię = "Jacek", Nazwisko = "Matulewski", NumerTelefonu = null, Adres = db.PobierzOsobę(5).Adres });
            podglądBazyDanych(db);

            IEnumerable<string> zapytanie = from Osoba osoba in db.Osoby
                                            where osoba.Nazwisko.Length <= 7
                                            orderby osoba.Nazwisko
                                            select osoba.ToString();

            Console.WriteLine("Zapytanie:");
            foreach(string s in zapytanie)
            {
                Console.WriteLine(s);
            }
        }
    }
}