﻿//Para<int, double> pid = new Para<int, double>() { Pierwszy = 1, Drugi = 2.0 };
//Console.WriteLine(pid);

Random r = new Random();

Para<int, double>[] tpid = new Para<int, double>[10];
for (int i = 0; i < tpid.Length; ++i)
{
    tpid[i] = new Para<int, double> { Pierwszy = r.Next(10), Drugi = r.Next(10) };
}
Console.WriteLine("Przed sortowaniem:");
foreach(var element in tpid) Console.WriteLine(element);
Array.Sort(tpid);
Console.WriteLine("Po sortowaniu:");
foreach (var element in tpid) Console.WriteLine(element);

class Para<T,S> : IComparable<Para<T,S>>
    where T : IComparable<T>
    where S : IComparable<S>
{
    public T Pierwszy = default(T);
    public S Drugi = default(S);

    public override string ToString()
    {
        return $"({Pierwszy}, {Drugi})";
    }

    public int CompareTo(Para<T,S>? other)
    {
        if(other == null) throw new ArgumentNullException(nameof(other));
        int wynik = Pierwszy.CompareTo(other.Pierwszy);
        if (wynik != 0) return wynik;
        else return Drugi.CompareTo(other.Drugi);
    }
}