﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Serialization;

namespace Serializacja
{
    public interface IDane
    {
        public string Imię { get; set; }
        public string Nazwisko { get; set; }
        public int? NumerTelefonu { get; set; }
        public DaneDodatkowe DaneDodatkowe { get; set; }
    }

    public class Dane : IDane
    {
        public string Imię { get; set; }
        public string Nazwisko { get; set; }
        public int? NumerTelefonu { get; set; }

        public DaneDodatkowe DaneDodatkowe { get; set; }

        public override string ToString()
        {
            return $"{Imię} {Nazwisko} ({(NumerTelefonu.HasValue ? NumerTelefonu.Value.ToString() : "---")}), {DaneDodatkowe.Ranga}";
        }
    }

    public enum Ranga { Palladyn, Czarodziej, Wojownik }

    public class DaneDodatkowe
    {
        public DateTime DataUrodzenia;
        public Ranga Ranga;
    }

    public static class DaneHelper
    {
        public static void ZapiszDane(this Dane dane, string ścieżkaPliku)
        {
            StreamWriter strumień = new StreamWriter(ścieżkaPliku);
            try
            {                
                XmlSerializer serializer = new XmlSerializer(typeof(Dane));
                XmlSerializerNamespaces xmlns = new XmlSerializerNamespaces();
                xmlns.Add("", "");
                //serializer.Serialize(strumień, dane);
                serializer.Serialize(strumień, dane, xmlns);
            }
            catch(Exception exc)
            {
                Console.Error.WriteLine("Błąd: " + exc.Message);
            }
            finally
            {
                strumień.Close();
                //strumień.Dispose(); //???
            }
        }

        public static Dane CzytajDane(string ścieżkaPliku)
        {
            StreamReader strumień = new StreamReader(ścieżkaPliku);
            try
            {
                XmlSerializer serializator = new XmlSerializer(typeof(Dane));
                Dane dane = (Dane)serializator.Deserialize(strumień);                
                return dane;
            }
            catch (Exception exc)
            {
                Console.Error.WriteLine("Błąd: " + exc.Message);
                return default(Dane);
            }
            finally
            {
                strumień.Close();
                //strumień.Dispose(); //???
            }
        }

        public static void Zapisz<T>(T dane, string ścieżkaPliku)
        {
            StreamWriter strumień = new StreamWriter(ścieżkaPliku);
            try
            {
                //XmlSerializer serializer = new XmlSerializer(typeof(T));
                XmlSerializer serializer = new XmlSerializer(dane.GetType());
                XmlSerializerNamespaces xmlns = new XmlSerializerNamespaces();
                xmlns.Add("", "");
                //serializer.Serialize(strumień, dane);
                serializer.Serialize(strumień, dane, xmlns);
            }
            catch (Exception exc)
            {
                Console.Error.WriteLine("Błąd: " + exc.Message);
            }
            finally
            {
                strumień.Close();
                //strumień.Dispose(); //???
            }
        }

        public static T Czytaj<T>(string ścieżkaPliku)
        {
            StreamReader strumień = new StreamReader(ścieżkaPliku);
            try
            {
                XmlSerializer serializator = new XmlSerializer(typeof(T));
                T dane = (T)serializator.Deserialize(strumień);
                return dane;
            }
            catch (Exception exc)
            {
                Console.Error.WriteLine("Błąd: " + exc.Message);
                return default(T);
            }
            finally
            {
                strumień.Close();
                //strumień.Dispose(); //???
            }
        }

        public static void ZapiszDane2(IDane dane, string ścieżkaPliku)
        {
            StreamWriter strumień = new StreamWriter(ścieżkaPliku);
            try
            {
                XmlSerializer serializer = new XmlSerializer(dane.GetType());
                XmlSerializerNamespaces xmlns = new XmlSerializerNamespaces();
                xmlns.Add("", "");
                //serializer.Serialize(strumień, dane);
                serializer.Serialize(strumień, dane, xmlns);
            }
            catch (Exception exc)
            {
                Console.Error.WriteLine("Błąd: " + exc.Message);
            }
            finally
            {
                strumień.Close();
                //strumień.Dispose(); //???
            }
        }
    }
}
