﻿using Serializacja;

Dane osoba1 = new Dane()
{
    Imię = "Antoni",
    Nazwisko = "Kałamaż",
    NumerTelefonu = 724728399,
    DaneDodatkowe = new DaneDodatkowe() { DataUrodzenia = DateTime.Now, Ranga = Ranga.Czarodziej }
};

Dane osoba2 = new Dane()
{
    Imię = "Wincenty",
    Nazwisko = "Pióro",
    NumerTelefonu = 12927927,
    DaneDodatkowe = new DaneDodatkowe() { DataUrodzenia = DateTime.Now.AddYears(-10), Ranga = Ranga.Palladyn }
};

Dane osoba3 = new Dane()
{
    Imię = "Karol",
    Nazwisko = "Atrament",
    NumerTelefonu = 283429874,
    DaneDodatkowe = new DaneDodatkowe() { DataUrodzenia = DateTime.Now, Ranga = Ranga.Wojownik }
};

Console.WriteLine("Oryginały:");
Console.WriteLine(osoba1.ToString());
Console.WriteLine(osoba2.ToString());
Console.WriteLine(osoba3.ToString());

Console.WriteLine("Serializacja");
osoba1.ZapiszDane("osoba1.xml");
osoba2.ZapiszDane("osoba2.xml");
osoba3.ZapiszDane("osoba3.xml");

DaneHelper.Zapisz<Dane>(osoba1, "osoba1a.xml");
DaneHelper.Zapisz(osoba1, "osoba1b.xml");
DaneHelper.Zapisz<Dane[]>(new Dane[] {osoba1, osoba2, osoba3}, "osoby.xml");

DaneHelper.ZapiszDane2(osoba1, "osoba1i.xml");
IDane i1 = osoba1;
DaneHelper.ZapiszDane2(i1, "osoba1j.xml");
DaneHelper.Zapisz<IDane>(i1, "osoba1k.xml");

Console.WriteLine("Deserializacja");
Dane osoba1kopia = DaneHelper.CzytajDane("osoba1.xml");
Dane osoba2kopia = DaneHelper.CzytajDane("osoba2.xml");
Dane osoba3kopia = DaneHelper.CzytajDane("osoba3.xml");

Console.WriteLine("Kopie:");
Console.WriteLine(osoba1.ToString());
Console.WriteLine(osoba2.ToString());
Console.WriteLine(osoba3.ToString());

Dane osoba1akopia = DaneHelper.Czytaj<Dane>("osoba1a.xml");
Console.WriteLine(osoba1akopia.ToString());

Console.WriteLine("Tablica");
Dane[] tablicaOsób = DaneHelper.Czytaj<Dane[]>("osoby.xml");
foreach (Dane osoba in tablicaOsób) Console.WriteLine(osoba.ToString());