﻿using System.Xml.Schema;
using Turing.Model;

class Program
{
    private static void wyświetlProgram(Turing.Model.Program program)
    {
        Console.WriteLine("Program:");
        foreach(var czwórka in program.Czwórki)
            Console.WriteLine(czwórka.ToString());
    }

    private static void wyświetlStanMaszyny(StanMaszyny stanMaszyny)
    {
        Console.WriteLine($"Taśma: {stanMaszyny.ToString()}");
        Console.WriteLine($"Stan głowicy: {stanMaszyny.StanGłowicy}");
        Console.WriteLine($"Indeks głowicy: {stanMaszyny.IndeksGłowicy}");
    }

    private static void Main(string[] args)
    {
        Console.WriteLine("Turing");

        bool powodzenie = true;

        StanMaszyny stanMaszyny = null;
        try
        {
            stanMaszyny = StanMaszyny.Load("taśma.txt");
            wyświetlStanMaszyny(stanMaszyny);
        }
        catch (Exception exc) 
        {
            Console.Error.WriteLine("Błąd przy próbie wczytania taśmy: " + exc.Message);            
            powodzenie = false;
        }

        Turing.Model.Program program = null;
        try
        {
            program = Turing.Model.Program.Load("program.txt");
            wyświetlProgram(program);
        }
        catch (Exception exc)
        {
            Console.Error.WriteLine("Błąd przy próbie wczytania programu: " + exc.Message);
            powodzenie= false;
        }

        if(!powodzenie)
        {
            Console.Error.WriteLine("Nie udało się zainicjować maszyny Turinga");
            Environment.Exit(1);
        }

        //wykonywanie programu
        Console.WriteLine("\nUruchamiam program...");
        char stanGłowicy = stanMaszyny.StanGłowicy;
        (char, char, char, char)? pasującaCzwórka = program.ZnajdźInstrukcjęDlaStanu(stanGłowicy, stanMaszyny.BieżącaWartośćWKomórce);
        if (pasującaCzwórka.HasValue)
        {
            Console.WriteLine(pasującaCzwórka.Value);
            stanMaszyny.WykonajInstrukcję(pasującaCzwórka.Value);
            wyświetlStanMaszyny(stanMaszyny);
        }
        else Console.WriteLine("Brak pasującej instrukcji");
    }
}
