using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using System.Reflection;

namespace AssemblyExplorer
{
    public partial class Form1 : Form
    {
        private Assembly a = null;

        public Form1()
        {
            InitializeComponent();
        }

        private void exitToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void aboutToolStripMenuItem_Click(object sender, EventArgs e)
        {
            MessageBox.Show(".NET Assembly Explorer (version " + Application.ProductVersion + ")  \n(c) Jacek Matulewski 2004 (rekompilacja dla .NET 4 - 2010)\n\nThe newest version can be downloaded from\nhttp://www.phys.uni.torun.pl/~jacek/download/  ", ".NET Assembly Explorer");
        }

        private void openAnAssemblyToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (openFileDialog1.ShowDialog() == DialogResult.OK)
            {
                try
                {
                    a = Assembly.LoadFrom(openFileDialog1.FileName);
                    toolStripStatusLabel1.Text = a.ToString();
                    this.Text = ".NET Assembly Explorer - " + a.Location;
                    listBox1.Items.Clear();
                    listBox1.Items.AddRange(a.GetTypes());
                    listBox1.SelectedIndex = 0;
                    assemblyInfoToolStripMenuItem.Enabled = true;                  
                }
                catch (Exception exc)
                {
                    MessageBox.Show("Error: " + exc.Message);
                }
            }
        }

        private void listBox1_SelectedIndexChanged(object sender, EventArgs e)
        {
            this.Cursor = Cursors.WaitCursor;
            
            Type type = a.GetType(listBox1.SelectedItem.ToString());

            treeView1.BeginUpdate();
            treeView1.Nodes.Clear();

            treeView1.Nodes.Add(new TreeNode("Info"));
            treeView1.Nodes[0].Nodes.Add(new TreeNode("Name: " + type.FullName));
            treeView1.Nodes[0].Nodes.Add(new TreeNode("Assembly: " + type.Assembly));
            treeView1.Nodes[0].Nodes.Add(new TreeNode("Attributes: " + type.Attributes));
            treeView1.Nodes[0].Nodes.Add(new TreeNode("Scope: " + (type.IsPublic ? "public" : "not public")));
            treeView1.Nodes[0].Nodes.Add(new TreeNode("Class: " + type.IsClass));

            treeView1.Nodes.Add(new TreeNode("Fields"));
            FieldInfo[] fields = type.GetFields();
            foreach (FieldInfo field in fields) treeView1.Nodes[1].Nodes.Add((field.IsStatic ? "static" : "") + "  " + field.FieldType + "  " + field.Name);

            treeView1.Nodes.Add(new TreeNode("Constructors"));
            ConstructorInfo[] constructors = type.GetConstructors();
            foreach (ConstructorInfo constructor in constructors)
            {
                string parametersStr = "";
                ParameterInfo[] parameters = constructor.GetParameters();
                foreach (ParameterInfo parameter in parameters) parametersStr += parameter.ParameterType + " " + parameter.Name + ",";
                if (parametersStr.Length > 0) parametersStr = parametersStr.Substring(0, parametersStr.Length - 1);
                treeView1.Nodes[2].Nodes.Add(type.Name + "(" + parametersStr + ")");
            }

            treeView1.Nodes.Add(new TreeNode("Methods"));
            MethodInfo[] methods = type.GetMethods();
            foreach (MethodInfo method in methods) treeView1.Nodes[3].Nodes.Add((method.IsStatic ? "  static" : "") + "  " + method.GetBaseDefinition());

            treeView1.Nodes.Add(new TreeNode("Properties"));
            PropertyInfo[] properties = type.GetProperties();
            foreach (PropertyInfo property in properties) treeView1.Nodes[4].Nodes.Add("" + property.PropertyType + "  " + property.Name + ",   {" + (property.CanRead ? "get; " : "") + (property.CanWrite ? "set;" : "") + "}");

            treeView1.Nodes.Add(new TreeNode("Events"));
            EventInfo[] events = type.GetEvents();
            foreach (EventInfo evnt in events) treeView1.Nodes[5].Nodes.Add("" + evnt.EventHandlerType + "  " + evnt.Name);

            treeView1.Nodes.Add(new TreeNode("Interfaces"));
            Type[] interaces = type.GetInterfaces();
            foreach (Type interf in interaces) treeView1.Nodes[6].Nodes.Add("" + interf.Name);

            treeView1.Nodes.Add(new TreeNode("Nested Types"));
            Type[] nestedTypes = type.GetNestedTypes();
            foreach (Type nestedType in nestedTypes) treeView1.Nodes[7].Nodes.Add("" + nestedType.Name);

            treeView1.EndUpdate();

            this.Cursor = Cursors.Default;
        }

        private void nETInfoToolStripMenuItem_Click(object sender, EventArgs e)
        {
            string systeminfo = "";
            systeminfo += "Operating system version: " + Environment.OSVersion;
            systeminfo += "\n.NET Framework version: " + Environment.Version;

            systeminfo += "\n\nComputer name: " + Environment.MachineName;
            systeminfo += "\nUser name: " + Environment.UserName;
            systeminfo += "\n\nWindows directory: " + Environment.GetEnvironmentVariable("windir");
            systeminfo += "\nSystem directory: " + Environment.SystemDirectory;

            int ms_sekunda = 1000;
            int ms_minuta = 60 * ms_sekunda;
            int ms_godzina = 60 * ms_minuta;
            int ms_doba = 24 * ms_godzina;
            int ile_ms = Environment.TickCount;
            int ile_dni = ile_ms / ms_doba;
            int reszta = ile_ms % ms_doba;
            int ile_godzin = reszta / ms_godzina;
            reszta %= ms_godzina;
            int ile_minut = reszta / ms_minuta;
            reszta %= ms_minuta;
            int ile_sekund = reszta / ms_sekunda;
            systeminfo += "\nDuration of current Windows session: " + ile_dni + " dni, " + ile_godzin + " h, " + ile_minut + " min, " + ile_sekund + " s";

            MessageBox.Show(systeminfo, ".NET Framework informations");
        }

        private void assemblyInfoToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (a == null)
            {
                MessageBox.Show("Choose the assembly first", this.Text, MessageBoxButtons.OK, MessageBoxIcon.Information);
                return;
            }

            string info = "";
            info += "Name:   " + a.FullName + "\n";
            info += "File:   " + a.Location + "\n";
            info += "Entry point:   " + a.EntryPoint + "\n";
            info += "Version:   " + a.ImageRuntimeVersion + "\n";

            /*
            string[] manfestResourceNames=a.GetManifestResourceNames();
            info+="Zasoby:   ";
            foreach(string s in manfestResourceNames) info+=s;
            */

            /*
            ManifestResourceInfo mri=a.GetManifestResourceInfo((a.GetManifestResourceNames())[0]);
            info+="Manifest:   "+mri.ResourceLocation;
            */

            MessageBox.Show(info, "Assembly info");
        }
    }
}