using System;

//dla ICompare
using System.Collections.Generic;

namespace Ataxx
{
	/// <summary>
	/// Opis klasy AtaxxSilnik.
	/// </summary>
	public class AtaxxSilnik
	{
		public int planszaSzer=7;
		public int planszaWys=7;
		protected byte[,] plansza=null;
		protected byte nrGraczaWykonujacegoNastepnyRuch=1;
        public const int iloscUstawienBlokow=13; //ostatnie - puste
        //0 - pole puste
        //1 - gracz 1
        //2 - gracz 2
        //3 - blok

        //public ReversiSilnik():this(7,7){}

        public AtaxxSilnik(int planszaSzer,int planszaWys,int ustawienieBlokow)
		{
            this.planszaSzer=planszaSzer;
            this.planszaWys=planszaWys;
            plansza=new byte[planszaSzer,planszaWys];

			for (int i=0; i<planszaSzer; i++)
				for (int j=0; j<planszaWys; j++)
					plansza[i,j]=0;

            //bloki
            //0 - bez blokow
            //1 - losowo wybrane ustawienie
            if (ustawienieBlokow==1) ustawienieBlokow=2+(new Random()).Next(AtaxxSilnikAI.iloscUstawienBlokow-1);

            switch (ustawienieBlokow)
            {
                case 2:
                    plansza[0,2]=3;
                    plansza[2,0]=3;
                    plansza[planszaSzer-1,planszaWys-3]=3;
                    plansza[planszaSzer-3,planszaWys-1]=3;
                    plansza[planszaSzer-3,0]=3;
                    plansza[planszaSzer-1,2]=3;
                    plansza[0,planszaWys-3]=3;
                    plansza[2,planszaWys-1]=3;
                    plansza[planszaSzer/2,planszaWys/2]=3;
                    plansza[planszaSzer/2-1,planszaWys/2]=3;
                    plansza[planszaSzer/2+1,planszaWys/2]=3;
                    plansza[planszaSzer/2,planszaWys/2-1]=3;
                    plansza[planszaSzer/2,planszaWys/2+1]=3;
                    break;

                case 3: //krzyz
                    for (int y=0;y<planszaWys;y++) plansza[planszaSzer/2,y]=3;
                    for (int x=0;x<planszaSzer;x++) plansza[x,planszaWys/2]=3;
                    break;

                case 4: //2 linie
                    for (int x=0;x<planszaSzer;x++)
                    {
                        plansza[x,planszaWys/2-1]=3;
                        //plansza[x,planszaWys/2]=3;
                        plansza[x,planszaWys/2+1]=3;
                    }
                    break;

                case 5: //podzial
                    for (int y=0;y<planszaWys;y++)
                    {
                        //plansza[x,planszaWys/2-1]=3;
                        plansza[planszaSzer/2,y]=3;
                        //plansza[x,planszaWys/2+1]=3;
                    }
                    break;

                case 6: //srodek
                    plansza[planszaSzer/2-1,planszaWys/2+1]=3;
                    plansza[planszaSzer/2,planszaWys/2+1]=3;
                    plansza[planszaSzer/2+1,planszaWys/2+1]=3;
                    plansza[planszaSzer/2-1,planszaWys/2]=3;
                    //plansza[planszaSzer/2,planszaWys/2]=3;
                    plansza[planszaSzer/2+1,planszaWys/2]=3;
                    plansza[planszaSzer/2-1,planszaWys/2-1]=3;
                    plansza[planszaSzer/2,planszaWys/2-1]=3;
                    plansza[planszaSzer/2+1,planszaWys/2-1]=3;
                    break;

                case 7:
                    for (int y=0;y<planszaWys;y++)
                    {
                        plansza[1,y]=3;
                        plansza[planszaSzer-2,y]=3;
                    }
                    for (int x=0;x<planszaSzer;x++)
                    {
                        plansza[x,1]=3;
                        plansza[x,planszaWys-2]=3;
                    }
                    break;

                case 8:
                    plansza[1,1]=3;
                    plansza[2,1]=3;
                    plansza[1,2]=3;
                    plansza[planszaSzer-3,1]=3;
                    plansza[planszaSzer-2,1]=3;
                    plansza[planszaSzer-2,2]=3;
                    plansza[1,planszaWys-2]=3;
                    plansza[2,planszaWys-2]=3;
                    plansza[1,planszaWys-3]=3;
                    plansza[planszaSzer-3,planszaWys-2]=3;
                    plansza[planszaSzer-2,planszaWys-3]=3;
                    plansza[planszaSzer-2,planszaWys-2]=3;
                    break;

                case 9:
                    plansza[1,1]=3;
                    plansza[planszaSzer-2,1]=3;
                    plansza[1,planszaWys-2]=3;
                    plansza[planszaSzer-2,planszaWys-2]=3;
                    break;

                case 10:
                    plansza[1,1]=3;
                    plansza[planszaSzer-2,1]=3;
                    plansza[1,planszaWys-2]=3;
                    plansza[planszaSzer-2,planszaWys-2]=3;
                    plansza[1,planszaWys/2]=3;
                    plansza[planszaSzer-2,planszaWys/2]=3;
                    plansza[planszaSzer/2,1]=3;
                    plansza[planszaSzer/2,planszaWys-2]=3;
                    break;

                case 11:
                    plansza[planszaSzer/2,planszaWys/2]=3;
                    plansza[planszaSzer/2-1,planszaWys/2-1]=3;
                    plansza[planszaSzer/2+1,planszaWys/2+1]=3;
                    plansza[planszaSzer/2-1,planszaWys/2+1]=3;
                    plansza[planszaSzer/2+1,planszaWys/2-1]=3;
                    plansza[planszaSzer/2-2,planszaWys/2-2]=3;
                    plansza[planszaSzer/2+2,planszaWys/2+2]=3;
                    plansza[planszaSzer/2-2,planszaWys/2+2]=3;
                    plansza[planszaSzer/2+2,planszaWys/2-2]=3;
                    break;

                case 12:
                    for (int i=0;i<planszaSzer;i++)
                        for (int j=0;j<planszaWys;j++)
                            if ( ((i+j)/2)!=0.5*(i+j) ) plansza[i,j]=3;
                    break;
            }

            /*
            //jak w Reversi
            plansza[3,3]=1;
            plansza[4,4]=1;
            plansza[3,4]=2;
            plansza[4,3]=2;
            */
            plansza[0,0]=1;
            plansza[planszaSzer-1,planszaWys-1]=1;
            plansza[0,planszaWys-1]=2;
			plansza[planszaSzer-1,0]=2;

			//TESTY
			/*
			for (int i=0; i<planszaSzer; i++)
				for (int j=0; j<planszaWys; j++)
					plansza[i,j]=1;
			plansza[0,0]=0;
			plansza[1,0]=0;
			plansza[0,1]=0;
			plansza[1,1]=0;
			plansza[7,0]=2;
			plansza[2,0]=2;
			plansza[0,7]=2;
			*/
		}

		public byte StanPola(int poziomo,int pionowo)
		{
			if ((poziomo<0) || (poziomo>=planszaSzer) || (pionowo<0) || (pionowo>=planszaWys))
				throw new Exception("Nieprawidowe wsprzdne pola");
			return plansza[poziomo,pionowo];
		}

		public byte NumerGraczaWykonujacegoNastepnyRuch()
		{
			return nrGraczaWykonujacegoNastepnyRuch;
		}

		public static string SymbolPola(int poziomo,int pionowo)
		{
			if ((poziomo>25) || (pionowo>8)) return "("+poziomo.ToString()+","+pionowo.ToString()+")";
			return ""+"ABCDEFGHIJKLMNOPQRSTUVWXYZ"[poziomo]+"123456789"[pionowo];
		}

        protected int DlugoscSkoku(int poziomo,int pionowo,int poziomoStart,int pionowoStart)
        {
            int dx=Math.Abs(poziomo-poziomoStart);
            int dy=Math.Abs(pionowo-pionowoStart);
            int odleglosc=Math.Max(dx,dy);
            //System.Windows.Forms.MessageBox.Show("Odleglosc="+odleglosc.ToString());
            return odleglosc;
        }

		private int UstawPionek(int poziomo,int pionowo,int poziomoStart,int pionowoStart,bool testowanie)
        {
            //czy prawidlowe wspolrzedne
            if ((poziomo<0) || (poziomo>=planszaSzer) || (pionowo<0) || (pionowo>=planszaWys))
                throw new Exception("Nieprawidowe wsprzdne pola");

            //czy istniejace pole nalezy do gracza
            if (plansza[poziomoStart,pionowoStart]!=nrGraczaWykonujacegoNastepnyRuch) return 0;

            //czy nowe pole nie jest juz zajete?
            if (plansza[poziomo,pionowo]!=0) return 0;

            int odleglosc=DlugoscSkoku(poziomo,pionowo,poziomoStart,pionowoStart);
            if ((odleglosc==0) || (odleglosc>2)) return 0;
            
            int poprawnyRuch=0;
            if (odleglosc==1) //rozbudowywanie kolonii
            {
                if (!testowanie) plansza[poziomo,pionowo]=nrGraczaWykonujacegoNastepnyRuch;
                poprawnyRuch=1;
            }
            if (odleglosc==2) //skok
            {
                if (!testowanie)
                {
                    plansza[poziomo,pionowo]=nrGraczaWykonujacegoNastepnyRuch;
                    plansza[poziomoStart,pionowoStart]=0;
                }
                poprawnyRuch=2;
            }

            //przejmowanie pol
            if (!testowanie)
            {
                byte nrPrzeciwnika=(byte)((nrGraczaWykonujacegoNastepnyRuch==1)?2:1);
                int xmin=Math.Max(poziomo-1,0);
                int xmax=Math.Min(poziomo+1,planszaSzer-1);
                int ymin=Math.Max(pionowo-1,0);
                int ymax=Math.Min(pionowo+1,planszaWys-1);
                for (int x=xmin;x<=xmax;x++)
                    for (int y=ymin;y<=ymax;y++)
                        if (plansza[x,y]==nrPrzeciwnika) plansza[x,y]=nrGraczaWykonujacegoNastepnyRuch;
            }

            //jezeli ruch zostal wykonany - zmiana gracza
            if ((poprawnyRuch>0) && (!testowanie)) nrGraczaWykonujacegoNastepnyRuch=(byte)((nrGraczaWykonujacegoNastepnyRuch==1)?2:1);

            return poprawnyRuch;
        }

		public int UstawPionek(int poziomo,int pionowo,int poziomoStart,int pionowoStart)
		{
			return UstawPionek(poziomo,pionowo,poziomoStart,pionowoStart,false);
		}

        //struktura do przechowywania informacji o mozliwym ruchu  polu planszy
        protected class MozliwyRuch
        {
            public int poziomo;
            public int pionowo;
            public int poziomoStart;
            public int pionowoStart;
            public int priorytet;

            public MozliwyRuch(int poziomo,int pionowo,int poziomoStart,int pionowoStart,int priorytet)
            {
                this.poziomo=poziomo;
                this.pionowo=pionowo;
                this.poziomoStart=poziomoStart;
                this.pionowoStart=pionowoStart;
                this.priorytet=priorytet;
            }
        }

        protected int TworzListeMozliwychRuchow(List<MozliwyRuch> mozliweRuchy)
        {
            int iloscRuchowPoprawnych=0;
            for (int poziomo=0;poziomo<planszaSzer;poziomo++)
                for (int pionowo=0;pionowo<planszaWys;pionowo++)
                {
                    if (plansza[poziomo,pionowo]==nrGraczaWykonujacegoNastepnyRuch)
                    {
                        //szukam pol w otoczeniu piona
                        int xmin=Math.Max(poziomo-2,0);
                        int xmax=Math.Min(poziomo+2,planszaSzer-1);
                        int ymin=Math.Max(pionowo-2,0);
                        int ymax=Math.Min(pionowo+2,planszaWys-1);
                        for (int x=xmin;x<=xmax;x++)
                            for (int y=ymin;y<=ymax;y++)
                                if (UstawPionek(x,y,poziomo,pionowo,true)>0)
                                {
                                    if (mozliweRuchy!=null) mozliweRuchy.Add(new MozliwyRuch(x,y,poziomo,pionowo,0));
                                    iloscRuchowPoprawnych++;
                                }
                    }
                }

            //System.Windows.Forms.MessageBox.Show("Ilo moliwych ruchw: "+iloscRuchowPoprawnych.ToString());
            return iloscRuchowPoprawnych;
        }

        public bool CzyMozliwyRuch()
		{
            return TworzListeMozliwychRuchow(null)>0;
		}

		public void Pass()
		{
			nrGraczaWykonujacegoNastepnyRuch=(byte)((nrGraczaWykonujacegoNastepnyRuch==1)?2:1);
		}

		private bool czyPat()
		{
			bool mozliwyRuchGracza1=CzyMozliwyRuch();
			Pass(); //zmiana gracza
			bool mozliwyRuchGracza2=CzyMozliwyRuch();
			Pass(); //powrot do wlasciwego gracza
			return ((!mozliwyRuchGracza1) && (!mozliwyRuchGracza2));
		}

		private bool czyWszystkiePolaZajete(int[] zliczenia)
		{
			for(int poziomo=0;poziomo<planszaSzer;poziomo++)
				for(int pionowo=0;pionowo<planszaWys;pionowo++)
					zliczenia[plansza[poziomo,pionowo]]++;

			return zliczenia[0]==0;
		}

		public int CzyKoniec(int[] zliczenia)
		{
            if (zliczenia==null) zliczenia=new int[4];
            //CZY W Ataxx MOZLIWY JEST PAT?
            //0 - gra jeszcze nie skonczona
            //1 - wygral gracz 1
            //2 - wygral gracz 2
            //3 - remis
            int kod=0;
            if (czyWszystkiePolaZajete(zliczenia) || czyPat())
            {
                if (zliczenia[1]==zliczenia[2]) kod=3;
                else kod=(zliczenia[1]>zliczenia[2])?1:2;
            }
            else
            {
                if (zliczenia[1]==0) kod=2;
                if (zliczenia[2]==0) kod=1;
            }

			return kod;
		}

		public byte this[int poziomo,int pionowo]
		{
			get
			{
				return StanPola(poziomo,pionowo);
			}
		}
	}

	public class AtaxxSilnikAI : AtaxxSilnik
	{
        public AtaxxSilnikAI(int planszaSzer,int planszaintWys,int ustawienieBlokow):base(planszaSzer,planszaintWys,ustawienieBlokow) { }

		#region AI
		//klasa potrzebna do sortowania ruchow wzgledem priorytetow
		private class PorownywaczRuchow : IComparer<MozliwyRuch>
		{
            public int Compare(MozliwyRuch ruch1,MozliwyRuch ruch2)
			{
				return ruch2.priorytet-ruch1.priorytet;
			}
		}

        private int[] BadajOtoczeniePola(int poziomo,int pionowo)
        {
            int[] zliczenia=new int[4]; 
            int xmin=Math.Max(poziomo-1,0);
            int xmax=Math.Min(poziomo+1,planszaSzer-1);
            int ymin=Math.Max(pionowo-1,0);
            int ymax=Math.Min(pionowo+1,planszaWys-1);
            for (int x=xmin;x<=xmax;x++)
                for (int y=ymin;y<=ymax;y++)
                {
                    if ((x==poziomo) && (y==pionowo)) continue;
                    zliczenia[plansza[x,y]]++;
                }
            return zliczenia;
        }

		//zasadnicza metoda AI
		public int[] ProponujNajlepszyRuch(bool wyswietlListeMozliwychRuchow,byte poziomTrudnosci)
		{
		    //deklaracja tablicy mozliwych ruchow
			List<MozliwyRuch> mozliweRuchy=new List<MozliwyRuch>();

			int skokPriorytetu=planszaSzer*planszaWys;

			//poszukiwanie mozliwych ruchow
            TworzListeMozliwychRuchow(mozliweRuchy);

            for (int i=0;i<mozliweRuchy.Count;i++)
            {
                MozliwyRuch mozliwyRuch=mozliweRuchy[i];
                int[] otoczenie=BadajOtoczeniePola(mozliwyRuch.poziomo,mozliwyRuch.pionowo);

                if (poziomTrudnosci>1)
                {
                    //zajmowac dziuple
                    if (otoczenie[0]==0) mozliwyRuch.priorytet+=skokPriorytetu*skokPriorytetu;

                    //nie tworzyc dziupli przez przeskok
                    int[] otoczenieStart=BadajOtoczeniePola(mozliwyRuch.poziomoStart,mozliwyRuch.pionowoStart);
                    if (otoczenieStart[0]==0) mozliwyRuch.priorytet-=skokPriorytetu*skokPriorytetu;

                    //unikac dziupli podwojnych
                    if (otoczenie[0]==1)
                    {
                        //szukam tego pola, ktore jest puste i sprawdzam, czy tez ma otoczenie[0]==1
                        int xmin=Math.Max(mozliwyRuch.poziomo-1,0);
                        int xmax=Math.Min(mozliwyRuch.poziomo+1,planszaSzer-1);
                        int ymin=Math.Max(mozliwyRuch.pionowo-1,0);
                        int ymax=Math.Min(mozliwyRuch.pionowo+1,planszaWys-1);
                        for (int x=xmin;x<=xmax;x++)
                            for (int y=ymin;y<=ymax;y++)
                            {
                                if ((x==mozliwyRuch.poziomo)&&(y==mozliwyRuch.pionowo)) continue;
                                if (plansza[x,y]==0)
                                {
                                    int[] otoczenieTowarzysza=BadajOtoczeniePola(x,y);
                                    if (otoczenieTowarzysza[0]==1) mozliwyRuch.priorytet-=skokPriorytetu*skokPriorytetu;
                                    break; //tylko jedno, wiec dalej nie ma co szukac
                                }
                            }
                    }
                }

                if (poziomTrudnosci>0)
                {
                    //ilosc przeciwnikow
                    byte nrPrzeciwnika=(byte)((nrGraczaWykonujacegoNastepnyRuch==1)?2:1);
                    mozliwyRuch.priorytet+=otoczenie[nrPrzeciwnika]*skokPriorytetu;

                    //budowanie kolonii
                    mozliwyRuch.priorytet+=2-DlugoscSkoku(mozliwyRuch.poziomo,mozliwyRuch.pionowo,mozliwyRuch.poziomoStart,mozliwyRuch.pionowoStart);
                }
            }

            if (wyswietlListeMozliwychRuchow)
            {
                string s="Lista moliwych ruchw:\n";
                foreach (MozliwyRuch mozliwyRuch in mozliweRuchy)
                {
                    s+=SymbolPola(mozliwyRuch.poziomoStart,mozliwyRuch.pionowoStart)+"-"+SymbolPola(mozliwyRuch.poziomo,mozliwyRuch.pionowo)+", priorytet "+mozliwyRuch.priorytet.ToString()+"\n";
                    //s+=DlugoscSkoku(mozliwyRuch.poziomo,mozliwyRuch.pionowo,mozliwyRuch.poziomoStart,mozliwyRuch.pionowoStart)+"\n";
                }
                System.Windows.Forms.MessageBox.Show(s);
            }


            MozliwyRuch najlepszyMozliwyRuch=null;
            if (poziomTrudnosci==0) 
            {
                //przypadkowy ruch
                najlepszyMozliwyRuch=(MozliwyRuch)mozliweRuchy[new Random().Next(mozliweRuchy.Count)]; 
            }
            else 
            {
                //wybor pola o najwiekszym priorytecie
                mozliweRuchy.Sort(new PorownywaczRuchow());
                najlepszyMozliwyRuch=(MozliwyRuch)mozliweRuchy[0];
            }
			
            int[] najlepszyInt={najlepszyMozliwyRuch.poziomo,najlepszyMozliwyRuch.pionowo,najlepszyMozliwyRuch.poziomoStart,najlepszyMozliwyRuch.pionowoStart};
			return najlepszyInt;
		}
	#endregion
	}

}

