﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using System.IO;

using Microsoft.Xna.Framework;
//using ITA106;

namespace UzycieTypowXNADoObliczen
{
    class Program
    {
        //prametry kontrolujace obliczenia
        static string nazwaPliku = @".\\wyniki.dat";
        static bool wydrukNaEkranie = false;
        static bool zapisDoPliku = true;
        const ITA106.SposobZrownoleglania obliczeniaRownolegle = ITA106.SposobZrownoleglania.FabrykaZadan;
        const int iloscPunktow = 10; //do rownoleglych: 10 - nie opłaca się, 100 - na granicy, 1000 - nadal bardzo słabo

        //wyniki (bez zapisu do pliku i na ekran) na maszynie dwurdzeniowej
        //N=10,   Sekwencyjnie=188 ms, ParallelFor=359 ms, Zadania=719 ms, FabrykaZadan=984 ms, Watki=5797 ms, PulaWatkow=703 ms
        //N=100   Sekwencyjnie=4906 ms, ParallelFor=4609 ms, Zadania=4969 ms, FabrykaZadan=7391 ms, Watki=9609 ms, PulaWatkow=6906 ms
        //N=1000, Sekwencyjnie=165531 ms, ParallelFor=153765 ms, Zadania=155203 ms, FabrykaZadan=170516 ms, Watki=168719 ms, PulaWatkow=188985 ms (sic!)

        static void Main(string[] args)
        {
            Console.WriteLine("Ewolucja oscylatorów sprzężonych (użycie Vector3 z XNA w zwykłej aplikacji konsolowej i testowanie obliczeń równoległych)");
            Console.WriteLine("Sposób zrównoleglenia: " + obliczeniaRownolegle.ToString());
            Console.WriteLine("Ilość cząstek: " + iloscPunktow);
            Console.WriteLine();

            ITA106.ZbiorPunktowMaterialnych zpm = new ITA106.ZbiorOscylatorowSprzezonych(iloscPunktow, 1, 0, 0, 1);
            zpm.ObliczeniaRownolegle = obliczeniaRownolegle;

            using (StreamWriter sw = new StreamWriter(nazwaPliku))
            {
                int czasStart = System.Environment.TickCount;
                float krokCzasowy = 0.01f;
                const int iloscKrokow = 10000;
                for (int krok = 0; krok < iloscKrokow; ++krok)
                {
                    if (krok > 0) zpm.KrokNaprzod(krokCzasowy, ITA106.Algorytm.algorytmVerleta);
                    
                    if (wydrukNaEkranie)
                    {
                        //konsola
                        Console.Write(krok.ToString() + ": ");
                        for (int i = 0; i < zpm.LiczbaPunktow; ++i) Console.Write(zpm[i].Polozenie.X + ", ");
                        Console.WriteLine();
                    }
                    if (zapisDoPliku)
                    {
                        //plik
                        sw.Write(krok * krokCzasowy + "  ");
                        for (int i = 0; i < zpm.LiczbaPunktow; ++i) sw.Write(zpm[i].Polozenie.X + "  ");
                        sw.WriteLine();
                    }
                }
                int czasKoniec = System.Environment.TickCount;
                int czasRoznica = czasKoniec-czasStart;
                Console.WriteLine("Czas obliczen: " + czasRoznica.ToString() + " ms");
            }


            

        }
    }
}
