﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;

namespace ITA106
{
    class ZbiorOscylatorowSprzezonych : ZbiorPunktowMaterialnych    
    {
        protected float k; //wspolczynnik sprezystosci
        protected float l; //odleglosc spoczynkowa
        protected float t; //wspolczynniki tlumienia (sily oporu)
        protected float tt; //wspolczynnik tlumienia oscylacji

        protected bool sprezystoscTylkoPrzyRozciaganiu = false;

        public ZbiorOscylatorowSprzezonych(int ilosc, float wspolczynnikSprezystosci, float wspolczynnikTlumienia, float wspolczynnikTlumieniaOscylacji, float dlugosc)
            : base(ilosc)
        {
            k = wspolczynnikSprezystosci;
            t = wspolczynnikTlumienia;
            tt = wspolczynnikTlumieniaOscylacji;
            l = dlugosc / (ilosc - 1);

            for (int i = 0; i < ilosc; ++i)
            {
                punkty[i].Polozenie = new Vector3(-dlugosc / 2 + i * l, 0, 0);
                punkty[i].Predkosc = Vector3.Zero; //spoczywajace
                punkty[i].Kolor = new Color(0, (float)i / (ilosc - 1), 1);
            }

            //ORYGINALNE WARUNKI POCZATKOWE Z XNA
            //punkty[0].Predkosc = new Vector3(0.3f, 0.1f, 0);
            //punkty[ilosc - 1].Predkosc = new Vector3(-0.3f, -0.1f, 0);

            //ZMIENIONE WARUNKI -> 1D
            punkty[0].Predkosc = new Vector3(0.3f, 0, 0);
            punkty[ilosc - 1].Predkosc = new Vector3(-0.3f, 0, 0);

            //poczatkowa predkosc srednia ma byc rowna zero
            ZerujPredkoscSrednia();
        }

        protected override Vector3 Sila(int indeks)
        {
            Vector3 silaZLewej = Vector3.Zero, silaZPrawej = Vector3.Zero;
            if (indeks > 0)
            {
                Vector3 doLewego = punkty[indeks - 1].Polozenie - punkty[indeks].Polozenie;
                float wychylenie = doLewego.Length() - l;
                if (!sprezystoscTylkoPrzyRozciaganiu || wychylenie > 0)
                {
                    doLewego.Normalize();
                    silaZLewej = k * wychylenie * doLewego;
                    Vector3 roznicaPredkosci = punkty[indeks - 1].Predkosc - punkty[indeks].Predkosc;
                    silaZLewej += tt * (doLewego * roznicaPredkosci) * doLewego;
                }
            }
            if (indeks < ilosc - 1)
            {
                Vector3 doPrawego = punkty[indeks + 1].Polozenie - punkty[indeks].Polozenie;
                float wychylenie = doPrawego.Length() - l;
                if (!sprezystoscTylkoPrzyRozciaganiu || wychylenie > 0)
                {
                    doPrawego.Normalize();
                    silaZPrawej = k * wychylenie * doPrawego;
                    Vector3 roznicaPredkosci = punkty[indeks + 1].Predkosc - punkty[indeks].Predkosc;
                    silaZPrawej += tt * (doPrawego * roznicaPredkosci) * doPrawego;
                }
            }
            Vector3 sila = silaZLewej + silaZPrawej;
            if (t != 0) sila -= 2 * punkty[indeks].Predkosc * t; //tlumienie
            return sila;
        }
    }

    class Lina : ZbiorOscylatorowSprzezonych
    {
        private Vector3 g; //przyspieszenie ziemskie

        public Lina(int ilosc, float wspolczynnikSprezystosci, float wspolczynnikTlumienia, float wspolczynnikTlumieniaOscylacji, float dlugosc,float przyspieszenieZiemskie)
           :base(ilosc,wspolczynnikSprezystosci,wspolczynnikTlumienia,wspolczynnikTlumieniaOscylacji,dlugosc)
        {
            g = przyspieszenieZiemskie*Vector3.Down;

            sprezystoscTylkoPrzyRozciaganiu = true;
            for (int i = 0; i < ilosc; i++)
            {
                punkty[i].Polozenie = new Vector3(punkty[i].Polozenie.X, 0.75f, punkty[i].Polozenie.Z);                
                punkty[i].Predkosc = Vector3.Zero;
            }
            UstawWiezy(0, true);
        }

        protected override Vector3 Sila(int indeks)
		{
            return base.Sila(indeks) + punkty[indeks].Masa * g;
		}
    }
}
