﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace DrugieSpotkanie_JezykCS
{
    class Program
    {
        static void PodwojnePetle()
        {
            for (int iz = 1; iz <= 4; iz++)
            {
                for (int iw = iz; iw < iz + 5; iw++)
                {
                    Console.Write(iw);
                }
                Console.WriteLine();
            }

            Console.WriteLine();

            const int N = 9;
            for (int iz = 1; iz <= N; iz++)
            {
                bool znakZmiany = true;
                //Console.Write(iz + " ");                
                int z = 1;
                for (int iw = 1; iw <= 2 * iz - 1; iw++)
                {
                    Console.Write(z);
                    if (znakZmiany) z++;
                    else z--;
                    if (z >= iz) znakZmiany = false;
                }
                Console.WriteLine();
            }

            Console.WriteLine();

            for (int i = 0; i < N; i++)
            {
                for (int j = 1; j <= i; j++)
                {
                    Console.Write(j);
                }

                for (int j = i + 1; j > 0; j--)
                {
                    Console.Write(j);
                }
                Console.WriteLine();
            }
        }

        static void CzytanieZKonsoli()
        {
            string łańcuch = "";

            Console.Write("Napisz swoje imię: ");
            łańcuch = Console.ReadLine();
            Console.WriteLine("Jesteś " + (łańcuch.EndsWith("a") ? "kobietą." : "mężczyzną."));

            Console.WriteLine();

            Console.WriteLine("Wpisz łańcuch (koniec po wpisaniu \"Koniec\"): ");
            do
            {
                Console.Write(DateTime.Now.ToString()+" $>");
                łańcuch = Console.ReadLine();
                Console.WriteLine("Echo: " + łańcuch);
            }
            while (!łańcuch.Equals("Koniec"));

            Console.WriteLine();

            Console.WriteLine("Reakcja na naciskane klawisze - wyświetlany kod znaku (koniec - Esc):");
            ConsoleKeyInfo kodZnaku;
            do
            {
                kodZnaku = Console.ReadKey();
                Console.WriteLine(" Wciśnięty znak: " + kodZnaku.KeyChar+" ("+kodZnaku.Key.ToString()+")");
            }
            while (kodZnaku.Key != ConsoleKey.Escape);
        }

        static void StatystykaBezPrzechowywaniaDanych()
        {
            Random r = new Random();
            int N = 100000;
            double średnia = 0;

            for (int i = 0; i < N; ++i)
            {
                int x = r.Next(6)+1;
                int y = r.Next(6)+1;
                int suma = x+y;
                //Console.Write(x + "-" + y + "\t");
                średnia += suma;
            }            
            średnia /= N;
            //Console.WriteLine();
            Console.WriteLine("Wartość średnia: " + średnia);
        }

        static void StatystykaTablica()
        {
            Random r = new Random();
            int N = 100000;            

            int[] t = new int[N];
            for (int i = 0; i < N; ++i)
            {
                int x = r.Next(6) + 1;
                int y = r.Next(6) + 1;
                t[i] = x + y;
            }
            Console.WriteLine();
            Console.WriteLine("Wartość średnia: " + t.Average());
            Console.WriteLine("Wartość minimalna: " + t.Min());
            Console.WriteLine("Wartość maksymalna: " + t.Max());
            Console.WriteLine("Suma: " + t.Sum());
            Console.WriteLine();

            double średnia = t.Average();
            double odchylenieStandardowe = 0;
            for (int i = 0; i < t.Count(); ++i)
            {
                odchylenieStandardowe += (t[i] - średnia) * (t[i] - średnia);
            }
            odchylenieStandardowe = Math.Sqrt(odchylenieStandardowe / N);
            Console.WriteLine("Odchylenie standardowe: " + odchylenieStandardowe);

            //wyrażenie Lambda
            odchylenieStandardowe = t.Aggregate(0.0, (wartość, element) => wartość += (element - średnia) * (element - średnia), wartość => Math.Sqrt(wartość / N));
            Console.WriteLine("Odchylenie standardowe: " + odchylenieStandardowe);
        }

        static void UżycieStringBuilder()
        {
            string s = "Wartości: ";
            for (int i = 0; i < 10; i++) s += " " + i.ToString();
            Console.WriteLine(s);

            StringBuilder sb = new StringBuilder("Wartości: ");
            for (int i = 0; i < 10; i++) sb.Append(" " + i.ToString());
            Console.WriteLine(sb);
        }

        static int? ZwrociAlboNieZwroci(int ziarno)
        {
            Random r = new Random(ziarno);
            int wartosc = r.Next(100);
            if (wartosc < 10) return null;
            else return wartosc;
        }

        /*
        static void Typy_CiagDalszy_Nullable()
        {
            int i = 0;
            double d = 0.0;
    
            Nullable<int> ni = null;
            Nullable<double> nd = null;

            int? qi = null;
            double? qd = null;
        }
        */

        enum DniTygodnia : byte { Niedziela = 1, Poniedziałek, Wtorek, Środa, Czwartek, Piątek, Sobota };

        static void TypWyliczeniowy()
        {
            //DniTygodnia dzienTygodnia = DniTygodnia.Sobota;
            DniTygodnia dzienTygodnia = (DniTygodnia)(DateTime.Now.DayOfWeek+1);
            
            byte nrDniaTygodnia = (byte)dzienTygodnia;
            Console.WriteLine("Numer dnia tygodnia: " + nrDniaTygodnia);

            Console.Write("Dziś jest ");
            switch (dzienTygodnia)
            {
                case DniTygodnia.Niedziela:
                    Console.Write("niedziela");
                    break;
                case DniTygodnia.Poniedziałek:
                    Console.Write("poniedziałek");
                    break;
                case DniTygodnia.Wtorek:
                    Console.Write("wtorek");
                    break;
                case DniTygodnia.Środa:
                    Console.Write("środa");
                    break;
                case DniTygodnia.Czwartek:
                    Console.Write("czwartek");
                    break;
                case DniTygodnia.Piątek:
                    Console.Write("piątek");
                    break;
                case DniTygodnia.Sobota:
                    Console.Write("sobota");
                    break;
                default:
                    throw new Exception("Błędny dzień tygodnia");
                    //Console.Write("Błędny dzień tygodnia");
                    //break;
            }
            Console.WriteLine(".");
        }

        static void OdczytajZakresLiczbCalkowitych(ref int min, out int max)
        {
            min = int.MinValue;
            max = int.MaxValue;
            Console.WriteLine("Zakres liczb całkowitych int to: [" + min + "," + max + "]");
        }

        static void ZwracanieWartosciPrzezReferencje()
        {
            int min = 0, max = 0;
            OdczytajZakresLiczbCalkowitych(ref min, out max);
            Console.WriteLine("Zakres liczb całkowitych int to: [" + min + "," + max + "]");
        }

        static void Main(string[] args)
        {
            PodwojnePetle();
            Console.WriteLine();

            CzytanieZKonsoli();
            Console.WriteLine();
            
            StatystykaBezPrzechowywaniaDanych();
            StatystykaTablica();
            Console.WriteLine();

            UżycieStringBuilder();
            Console.WriteLine();

            TypWyliczeniowy();
            Console.WriteLine();

            ZwracanieWartosciPrzezReferencje();
            Console.WriteLine();

            Console.WriteLine("Naciśnij ENTER...");
            Console.ReadLine();
        }
    }
}
