﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace DrugieSpotkanie_Czesc2
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();

            #if DEBUG
            //MessageBox.Show("Tryb debugowania");
            label1.ForeColor = Color.Red;
            label1.Text = "Skompilowane w trybie debugowania";
            #else
            //MessageBox.Show("Tryb release");
            label1.ForeColor = Color.Green;
            label1.Text = "Skompilowane w trybie release";
            #endif
        }

        int Kwadrat(int arg)
        {
            return arg * arg;
        }

        byte Inc(byte arg)
        {
            if (arg >= byte.MaxValue) throw new ArgumentOutOfRangeException("Za duża wartość argumentu. Wynik przekroczyłby zakres typu byte");
            return Convert.ToByte(arg + 1); //operatory arytmetyczne nie są zdefiniowane dla typów byte i short, niejawna konwersja na int
        }

        delegate int TypFunkcjiKwadrat(int arg);
        delegate void TypAkcjiShow(int arg);
        delegate byte TypFunkcjiInc(byte arg);

        private void Delegacje_WyrazeniaLambda()
        {
            TypFunkcjiKwadrat metoda = Kwadrat;
            //metoda += Kwadrat;

            int wynik = Kwadrat(2);
            MessageBox.Show("Oryginalna metoda, Wynik: " + wynik);

            wynik = metoda(2);
            MessageBox.Show("Delegacja, Wynik: " + wynik);

            Func<int, int> lambda = (int arg) => arg* arg;
            TypFunkcjiKwadrat lambda1 = (int arg) => arg * arg;
            wynik = lambda(2);
            MessageBox.Show("Wyrazenie Lambda, Wynik: " + wynik);

            //----------------------

            Action<string> show = (string s) => { MessageBox.Show(s); };
            Func<byte, byte> lambdaInc = (byte arg) => Convert.ToByte(arg + 1);
            Func<int, int, bool> lambdaComp = (int x, int y) => x == y;
        }

        private void button1_Click(object sender, EventArgs e)
        {
            Delegacje_WyrazeniaLambda();
        }

        private void RozszerzeniaLinq()
        {
            Random r = new Random();
            const int N = 100;
            int[] tablica = new int[N];
            for (int i = 0; i < N; ++i) tablica[i] = r.Next(1000);

            int ileElementowWTablicy = tablica.Count();
            MessageBox.Show("Ile elementów: " + ileElementowWTablicy);

            int ileElementowWiekszychNiz500 = tablica.Count((int element) => element > 500);
            MessageBox.Show("Ile elementów większych niż 500: " + ileElementowWiekszychNiz500);

            decimal sumaKwadratow = tablica.Sum((int element) => element * element);
            MessageBox.Show("Suma kwadratów: " + sumaKwadratow);

            double średnia = tablica.Average();
            double średniaBezwzglednychOdchyleń = tablica.Average((int element) => (Math.Abs(element - średnia)));
            MessageBox.Show("Średnia: " + średnia + "\nŚrednia bezwzglednych odchyleń: " + średniaBezwzglednychOdchyleń);

            //var pod_kolekcja = tablica.Select((int element) => element - 500);
            //var pod_kolekcja = tablica.Where((int element) => element > 500);
            //var pod_kolekcja = tablica.Where((int element) => element > 500).Select((int element) => element - 500);
            //var pod_kolekcja = tablica.OrderBy((int element) => element);
            var pod_kolekcja = tablica.Where((int element) => element > 500).OrderBy((int element) => element).Select((int element) => element - 500);
            string s = "Bez zapytania:\n";
            foreach (int element in pod_kolekcja) s += element + "\t";
            MessageBox.Show(s);
            MessageBox.Show("Wielkość nowej kolekcji (>500): " + pod_kolekcja.Count());

            pod_kolekcja = from element in tablica
                               where element > 500
                               orderby element
                               select element - 500;

            s = "Z zapytaniem:\n";
            foreach (int element in pod_kolekcja) s += element + "\t";
            MessageBox.Show(s);
            MessageBox.Show("Wielkość nowej kolekcji (>500): " + pod_kolekcja.Count());
        }

        private void ZapytaniaLinq()
        {
            string[] tablicaImion = new string[] { "Jacek", "Kasia", "Karolina", "Bartek", "Anna", "Ludmiła", "Tomek", "Dawid", "Kamila", "Kalina" };
            
            var wynikZapytaniaLinq = from string element in tablicaImion
                                     where element.EndsWith("a") && element.Length > 5
                                     orderby element descending
                                     select element.ToUpper();

            string s = "";
            foreach (string element in wynikZapytaniaLinq) s += element + "\n";
            MessageBox.Show(s);            

            wynikZapytaniaLinq = from imię in tablicaImion
                                 orderby imię.Length
                                 select imię.Replace('a', '#').Replace('A', '#');

            s = "";
            foreach (string element in wynikZapytaniaLinq) s += element + "\n";
            MessageBox.Show(s);            
        }

        private void button2_Click(object sender, EventArgs e)
        {
            RozszerzeniaLinq();
            ZapytaniaLinq();
        }
           
        private void button3_Click(object sender, EventArgs e)
        {
            Random r = new Random();
            List<int> li = new List<int>();
            for (int i = 0; i < 100; ++i)
            {
                int el = r.Next(100);
                if(el>50) li.Add(el);
            }

            li.Sort();

            string s ="";
            foreach (int el in li) s += el.ToString() + "\t";
            MessageBox.Show(s);

            //---------------

            SortedList<string, string> sortowanySlownik = new SortedList<string, string>();
            sortowanySlownik.Add("Sting", "Gordon Summer");
            sortowanySlownik.Add("Bolesław Prus", "Aleksander Głowacki");
            sortowanySlownik.Add("Pola Negri", "Barbara Chałupiec");
            sortowanySlownik.Add("John Wayne", "Marion Michel Morrison");
            sortowanySlownik.Add("Chico", "Leonard Marx");
            sortowanySlownik.Add("Ronaldo", "Luiz Nazario de Lima");

            s = "";
            foreach (KeyValuePair<string,string> el in sortowanySlownik) s += el.Key + " = " + el.Value + "\n";
            MessageBox.Show(s);

            MessageBox.Show(sortowanySlownik["Sting"]);

            //------------------

            Queue<int> kolejka = new Queue<int>();
            Stack<int> stos = new Stack<int>();

            for (int i = 0; i < 10; ++i)
            {
                kolejka.Enqueue(i);
                stos.Push(i);
            }

            s = "";
            for (int i = 0; i < 10; ++i)
            {
                s += kolejka.Dequeue() + " " + stos.Pop() + "\n";
            }
            MessageBox.Show(s);

            var zapytanieLista = from element in li
                                 select element;

            var zapytanieSlownik = from element in sortowanySlownik
                                   select element;

            var zapytanieKolejka = from element in kolejka
                                   select element;

            var zapytanieStos = from element in stos
                                select element;
        }

        private void button4_Click(object sender, EventArgs e)
        {
            //typy wartościowe i referencyjne
            int a = 1;
            int b = a;
            MessageBox.Show("a=" + a + ", b=" + b);
            a = 2;
            MessageBox.Show("a=" + a + ", b=" + b);

            Button c = new Button();
            c.Text = "UMK";
            c.Width = 100;
            c.Left = 250;
            c.Top = 10;
            c.BackColor = SystemColors.ButtonFace;
            c.Parent = this;

            Button d = c;
            MessageBox.Show("c.Text=" + c.Text + "\nd.Text=" + d.Text);
            d.Text = d.Text + " WFAiIS";
            d.Left = 10;
            d.Parent = panel1;
            MessageBox.Show("c.Text=" + c.Text + "\nd.Text=" + d.Text);
        }
    }
}
