﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ProgramowanieObiektowe
{
    class Kot
    {
        private bool pełnyBrzuch = false;

        public Kot(bool pełnyBrzuch)
        {
            this.pełnyBrzuch = pełnyBrzuch;
        }

        public bool PełnyBrzuch
        {
            get
            {
                return pełnyBrzuch;
            }
        }

        public virtual void Miauczy(string łańcuch)
        {
            Console.WriteLine("Miałczę: " + łańcuch);
            Console.WriteLine(pełnyBrzuch ? "Jestem śpiący" : "Jestem głodny");
        }

        public void Jedz()
        {
            if (pełnyBrzuch) throw new Exception("Nie chcę jeść");
            else pełnyBrzuch = true;
        }

        public void IdźNaSpacer()
        {
            pełnyBrzuch = false;
        }

        public override string ToString()
        {
            return "Miauuu...";
        }
    }

    class Pers : Kot
    {
        bool czySzczęśliwy = false;

        public Pers()
            : base(false)
        {
        }

        public void Głaskaj(bool czyWystarczającoDługo = true)
        {
            czySzczęśliwy = czyWystarczającoDługo;
        }

        public override void Miauczy(string łańcuch)
        {
            Console.WriteLine("Wrrrrrrrr....\nChcę jeść");
        }
    }
}
